/* $Id: createLayoutServer.cpp,v 1.8 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.8 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "voronoi/voronoi.h"
#include "fdp/fdp.h"
#include "shortspline/shortspline.h"
#include "dynadag/DynaDAG.h"
#include "common/ColorByAge.h"
#include "incrface/createLayoutServer.h"
#include "common/breakList.h"

using namespace std;

// is it possible to do this w/out the struct?
typedef Server *(*creatorf)(Layout *cli,Layout *curr);
template<typename ST>
struct tcreator {
	static Server *create(Layout *client,Layout *current) {
		return new ST(client,current);
	}
};
struct creators : map<DString,creatorf> {
	creators() {
		creators &me = *this;

		me["dynadag"] = tcreator<DynaDAG::DynaDAGServer>::create;
		me["fdp"] = tcreator<FDP::FDPServer>::create;
		me["voronoi"] = tcreator<Voronoi::VoronoiServer>::create;
		me["visspline"] = tcreator<ShortSpliner>::create;
		me["labels"] = tcreator<LabelPlacer>::create;
		me["shapegen"] = tcreator<ShapeGenerator>::create;
        me["colorbyage"] = tcreator<ColorByAge>::create;
	}
} g_creators;
Server *createLayoutServer(Layout *client,Layout *current) {
	UpdateCurrent *uc = new UpdateCurrent(client,current);
	CompoundServer *eng = new CompoundServer(client,current);
	eng->actors.push_back(uc); // obligatory
	DString &serverlist = gd<StrAttrs>(client)["engines"];
	if(serverlist.empty())
		serverlist = "shapegen,dynadag,labels,colorbyage";
    //gd<StrAttrs>(client)["agecolors"] = "green,blue,black";
    vector<DString> engs;
    breakList(serverlist,engs);
    for(vector<DString>::iterator ei = engs.begin(); ei!=engs.end(); ++ei) {
		creatorf crea = g_creators[*ei];
		if(!crea) {
			delete eng;
			ServerUnknown su;
			su.serverName = *ei;
			throw su;
		}
		Server *server = crea(client,current);
		eng->actors.push_back(server);
	}

	return eng;
}
