#ifndef MAIN_H

#include <limits.h>

#define MAX_BUFFER_LENGTH 255

#define NAMELEN     MAX_BUFFER_LENGTH
#define HOSTNAMELEN MAX_BUFFER_LENGTH
#define COMMANDLEN  (PATH_MAX + NAME_MAX)
#define ICONLEN     (PATH_MAX + NAME_MAX)
#define ARGUMENTSLEN     ARG_MAX
#define USERNAMELEN	MAX_BUFFER_LENGTH

#define GCONF_RCM_VERSION "/apps/grcm/Version"
#define GCONF_RCM_SORTING_OPTION "/apps/grcm/SortingOption"
#define GCONF_RCM_DISPLAY_USERNAMES "/apps/grcm/DisplayUserNames"
#define GCONF_RCM_TERMINAL_OPTION "/apps/grcm/TerminalProgram"
#define GCONF_RCM_TERMINAL_ARGUMENTS_OPTION "/apps/grcm/TerminalProgramArguments"
#define GCONF_CONNECTION_TYPES_DIR "/apps/grcm/connection_types"
#define GCONF_CONNECTIONS_DIR "/apps/grcm/connections"
#define GCONF_MAIN_WINDOW_WIDTH "/apps/grcm/MainWindowWidth"
#define GCONF_MAIN_WINDOW_HEIGHT "/apps/grcm/MainWindowHeight"
#define GCONF_CONNECTION_TYPES_WINDOW_WIDTH "/apps/grcm/ConnectionTypesWindowWidth"
#define GCONF_CONNECTION_TYPES_WINDOW_HEIGHT "/apps/grcm/ConnectionTypesWindowHeight"
#define GCONF_CONNECTIONS_WINDOW_WIDTH "/apps/grcm/ConnectionsWindowWidth"
#define GCONF_CONNECTIONS_WINDOW_HEIGHT "/apps/grcm/ConnectionsWindowHeight"
#define GCONF_MAIN_VIEW_AS_ICONVIEW "/apps/grcm/MainViewAsIconView"

extern GtkWidget *MainWindow;
extern GtkWidget *ConnectionTypesWindow;
extern GtkWidget *ConnectionsWindow;
extern GtkWidget *PropertiesDialog;

extern GSList *ConnectionsSList;
extern gboolean ConnectionsSListIsDirty;

extern GSList *ConnectionTypesSList;
extern gboolean ConnectionTypesSListIsDirty;

extern gchar* TerminalProgram;
extern gchar* TerminalProgramOptions;

typedef enum 
{
	SORT_NONE = 0,
	SORT_ASCENDING,
	SORT_DESCENDING,
	SORT_TYPE
}SORT_OPTION;

extern SORT_OPTION SortOption;
extern gboolean DisplayUsernameInMainWindow;

enum
{
	CONNECTION_NAME_COLUMN,
	CONNECTION_HOSTNAME_COLUMN,
	CONNECTION_TYPE_COLUMN,
	CONNECTION_N_COLUMNS
};

typedef struct Connection
{
	gchar Name[NAMELEN];
	gchar Hostname[HOSTNAMELEN];
	gint Type;
	gchar Username[USERNAMELEN];
	gchar Arguments[ARGUMENTSLEN];
	gboolean Dirty;
}
Connection;

enum
{
	CONNECTION_TYPE_NAME_COLUMN,
	CONNECTION_TYPE_COMMAND_COLUMN,
	CONNECTION_TYPE_ARGS_COLUMN,
	CONNECTION_TYPE_TERMINAL_COLUMN,
	CONNECTION_TYPE_ICON_COLUMN,
	CONNECTION_TYPE_N_COLUMNS
};

typedef struct ConnectionType
{
	gchar Name[NAMELEN];
	gchar Command[COMMANDLEN];
	gchar Arguments[ARGUMENTSLEN];
	gboolean Terminal;
	gchar Icon[ICONLEN];
	gboolean Dirty;
}
ConnectionType;

void rcm_quit (void);
void rcm_update_main_window (void);
void rcm_warn (const gchar * msg, GtkWidget * parent);
void rcm_error (const gchar * msg, GtkWidget * parent);
void rcm_first_run (void);
void rcm_upgrade (gchar * version);

GtkWidget *CreateConnectionTypesWindow (void);
void rcm_clear_types_window (void);
gboolean rcm_save_type (const ConnectionType type);
ConnectionType *rcm_find_type_by_name_in_list (const gchar * name, GSList * list);
void rcm_remove_all_types_from_disk ();
void rcm_update_connectiontypes_window_list ();
gboolean rcm_save_types_to_disk ();
gboolean rcm_load_types_from_disk ();
gint rcm_gconf_client_all_types_dirs (GError ** err);
void rcm_select_type_by_name (gchar * name);
gint rcm_lookup_type_by_name (gchar * name);
void rcm_show_ConnectionTypesWindow();

GtkWidget *CreateConnectionsWindow (void);
void rcm_clear_connections_window (void);
void rcm_update_connections_window_list (void);
gboolean rcm_save_connections_to_disk ();
gboolean rcm_load_connections_from_disk ();
Connection *rcm_remove_connection_from_list_by_name (const gchar * name, GSList * list);
Connection *rcm_find_connection_by_name_in_list (const gchar * name, GSList * list);
gboolean rcm_save_connection (const Connection connection);
void rcm_select_connection_by_name (gchar * name);
void rcm_remove_all_connections_from_disk (void);
gint rcm_gconf_client_all_connections_dirs (GError ** err);
void rcm_select_connection_by_index (gint num);
gboolean rcm_launch_connection_by_name (gchar * name);
void rcm_translate_arg(gchar* args, const gchar* arg, const gchar* fspec, guint length);

gint rcm_compare_Ascending(gconstpointer a, gconstpointer b);
gint rcm_compare_Descending(gconstpointer a, gconstpointer b);
gint rcm_compare_Types(gconstpointer a, gconstpointer b);
void rcm_ascending_sort(void);
void rcm_descending_sort(void);
void rcm_type_sort(void);

#endif
