/*  gtk-imonc - imond client for fli4l
 *  Copyright (C) 2001 Stefan Strigler <zeank@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "remote_update.h"

#define HOMEPAGE_URL "http://userpage.fu-berlin.de/~zeank/gtk-imonc/"

/* [zeank]: being q'n'd -> this shouldn't go here */
GtkWidget *gtk_imonc, *gtk_miniimonc;
GtkWidget *halt_warning, *reboot_warning;
GtkWidget *reconnect_dialog;
GtkWidget *rightclick_menu;

gboolean is_mini;
gboolean start_mini;

GdkPixmap *online_icon, *offline_icon;
GdkBitmap *online_icon_mask, *offline_icon_mask;

gchar admin_passwd[64];

gchar *salt;

void
on_dial_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data);

void
on_hangup_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

void
on_addlink_button_clicked              (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_dialmode_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

gboolean
on_default_route_menu_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

void
on_auth_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data);

void
on_halt_warning_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data);

void
on_reboot_warning_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data);


void
on_remlink_button_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_admin_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data);

void 
on_default_route_selected							 (GtkMenuShell *menu_shell, 
																				gpointer data);

void
on_dialmode_selected										(GtkMenuShell *menu_shell, 
																				 gpointer data);

void
on_reconnect_ok_button_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_calls_reset_button_clicked          (GtkButton       *button,
                                        gpointer         user_data);

void
on_calls_refresh_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);

void
on_notebook_switch_page                (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data);


void
on_imondlog_reset_button_clicked       (GtkButton       *button,
                                        gpointer         user_data);

void
on_reboot_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

void
on_halt_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data);

void
on_circuit_config_button_clicked       (GtkButton       *button,
                                        gpointer         user_data);

void
on_edit_circuit_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data);

void
on_circuits_clist_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_news_refresh_button_clicked         (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_admin_passwd_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

gboolean
on_auth_password_key_press_event       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

void
on_imondlog_export_clicked             (GtkButton       *button,
                                        gpointer         user_data);

void
on_calls_export_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_support_button_clicked              (GtkButton       *button,
                                        gpointer         user_data);
gboolean
on_traffic_info_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data);

void
on_handlebox_child_detached            (GtkHandleBox    *handlebox,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

void
on_handlebox_child_attached            (GtkHandleBox    *handlebox,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

gboolean
on_remote_auth_password_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

void
on_remote_auth_ok_clicked              (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_gtk_imonc_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

void
on_mini_view_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_call_checkbutton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

gboolean
on_preferences_dialog_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

void
on_admin_mode_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_admin_mode_okbutton_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_preferences_cancelbutton_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
on_preferences_okbutton_clicked        (GtkButton       *button,
                                        gpointer         user_data);
void
on_fileselection_ok_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_web_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_opt_checkbutton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_trayicon_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

gboolean
on_gtk_imonc_delete                    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);
