// statistics.c
// ------------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see statistics.h for spec.

#include "statistics.h"
#include <stream.h>
#include <math.h>
#define NL << "\n"

statistics::statistics()
{
	eventcount = 0; 
	sum = 0.0;		sumsquared = 0.0;
	max = -999999999;	min = 999999999;
}
void statistics::reset()
{
	eventcount = 0; 
	sum = 0.0;		sumsquared = 0.0;
	max = -999999999;	min = 999999999;
}
int statistics::print( char * label )
{
	if( eventcount == 0 ) return 0;
	float mean = sum / eventcount;
	cout << label << "Mean ";
/*
	if( mean > 100.0 )
//	  cout << int(mean);
	  cout << form( "%10.0f", mean );
	else if( mean > 10.0 )	cout << form( "%.1f", mean );
	else			cout << form( "%.2f", mean );
*/
	cout << mean;

	cout <<	" on " << eventcount << " events.\n";
	if( eventcount > 1 ) {
		if( max == min ) cout << "\tMax = min = " << min;
		else{
			cout << "\tMax " << max << " min " << min;
			float variance = (sumsquared - (sum*sum/eventcount))
				/ (eventcount-1);
			if( variance > 0.0 ) {
			    float stddev = sqrt( variance );
			    cout << "\tStandard deviation ";
/*
			    if( stddev > 100.0 ) 
				    cout << form( "%.0f", stddev);
			    else if( stddev > 10.0 ) 
				    cout << form( "%.1f", stddev);
			    else    cout << form( "%.2f", stddev);
*/
			    cout << stddev;
			}
		}
		cout NL;
	}
	return (int) mean;
}
void statistics::note( int value )
{
	eventcount++;
	float fvalue = (float)value;
	sum += fvalue;
	sumsquared += ( fvalue * fvalue );
	if( max < value ) max = value;
	if( min > value ) min = value;
}

