// -*- C++ -*-

#ifndef _FREESLLIST_H_
#define _FREESLLIST_H_

#include <assert.h>

/**
 * @class FreeSLList
 * @brief A "memory neutral" singly-linked list,
 *
 * Uses the free space in objects to store
 * the pointers.
 */


class FreeSLList {
public:

  inline FreeSLList (void)
  {}

  class Entry;
  
  inline void clear (void) {
    head.next = &head;
  }

  /// Get the head of the list.
  inline Entry * get (void) {
    const Entry * e = head.next;
    if (e == &head) {
      return NULL;
    }
    head.next = e->next;
    //    printf ("get: num = %d\n", num);
    //    head.next->prev = &head;
    return const_cast<Entry *>(e);
  }

  inline Entry * remove (void) {
    const Entry * e = head.next;
    if (e == &head) {
      return NULL;
    }
    head.next = e->next;
    return const_cast<Entry *>(e);
  }
  
  inline void insert (Entry * e) {
    e->next = head.next;
    head.next = e;
    //    printf ("insert: num = %d\n", num);
  }

  class Entry {
  public:
    Entry (void)
      : next (this)
    {}
    Entry * next;
  private:
    Entry (const Entry&);
    Entry& operator=(const Entry&);
  };
  
private:
  Entry head;
};


#endif




