#include "entities.h"

map<char,string> Entities::m_entityMap;
bool Entities::m_filled=false;

void Entities::InitEntities(){
  m_filled=true;
  m_entityMap[34]="quot";
  m_entityMap[38]="amp";
  m_entityMap[39]="#39";
  m_entityMap[60]="lt";
  m_entityMap[62]="gt";
  m_entityMap[160]="nbsp";
  m_entityMap[161]="iexcl";
  m_entityMap[162]="cent";
  m_entityMap[163]="pound";
  m_entityMap[164]="curren";
  m_entityMap[165]="yen";
  m_entityMap[166]="brvbar";
  m_entityMap[167]="sect";
  m_entityMap[168]="uml";
  m_entityMap[169]="copy";
  m_entityMap[170]="ordf";
  m_entityMap[171]="laquo";
  m_entityMap[172]="not";
  m_entityMap[173]="shy";
  m_entityMap[174]="reg";
  m_entityMap[175]="macr";
  m_entityMap[176]="deg";
  m_entityMap[177]="plusmn";
  m_entityMap[178]="sup2";
  m_entityMap[179]="sup3";
  m_entityMap[180]="acute";
  m_entityMap[181]="micro";
  m_entityMap[182]="para";
  m_entityMap[183]="middot";
  m_entityMap[184]="cedil";
  m_entityMap[185]="sup1";
  m_entityMap[186]="ordm";
  m_entityMap[187]="raquo";
  m_entityMap[188]="frac14";
  m_entityMap[189]="frac12";
  m_entityMap[190]="frac34";
  m_entityMap[191]="iquest";
  m_entityMap[192]="Agrave";
  m_entityMap[193]="Aacute";
  m_entityMap[194]="Acirc";
  m_entityMap[195]="Atilde";
  m_entityMap[196]="Auml";
  m_entityMap[197]="Aring";
  m_entityMap[198]="AElig";
  m_entityMap[199]="Ccedil";
  m_entityMap[200]="Egrave";
  m_entityMap[201]="Eacute";
  m_entityMap[202]="Ecirc";
  m_entityMap[203]="Euml";
  m_entityMap[204]="Igrave";
  m_entityMap[205]="Iacute";
  m_entityMap[206]="Icirc";
  m_entityMap[207]="Iuml";
  m_entityMap[208]="ETH";
  m_entityMap[209]="Ntilde";
  m_entityMap[210]="Ograve";
  m_entityMap[211]="Oacute";
  m_entityMap[212]="Ocirc";
  m_entityMap[213]="Otilde";
  m_entityMap[214]="Ouml";
  m_entityMap[215]="times";
  m_entityMap[216]="Oslash";
  m_entityMap[217]="Ugrave";
  m_entityMap[218]="Uacute";
  m_entityMap[219]="Ucirc";
  m_entityMap[220]="Uuml";
  m_entityMap[221]="Yacute";
  m_entityMap[222]="THORN";
  m_entityMap[223]="szlig";
  m_entityMap[224]="agrave";
  m_entityMap[225]="aacute";
  m_entityMap[226]="acirc";
  m_entityMap[227]="atilde";
  m_entityMap[228]="auml";
  m_entityMap[229]="aring";
  m_entityMap[230]="aelig";
  m_entityMap[231]="ccedil";
  m_entityMap[232]="egrave";
  m_entityMap[233]="eacute";
  m_entityMap[234]="ecirc";
  m_entityMap[235]="euml";
  m_entityMap[236]="igrave";
  m_entityMap[237]="iacute";
  m_entityMap[238]="icirc";
  m_entityMap[239]="iuml";
  m_entityMap[240]="eth";
  m_entityMap[241]="ntilde";
  m_entityMap[242]="ograve";
  m_entityMap[243]="oacute";
  m_entityMap[244]="ocirc";
  m_entityMap[245]="otilde";
  m_entityMap[246]="ouml";
  m_entityMap[247]="divide";
  m_entityMap[248]="oslash";
  m_entityMap[249]="ugrave";
  m_entityMap[250]="uacute";
  m_entityMap[251]="ucirc";
  m_entityMap[252]="uuml";
  m_entityMap[253]="yacute";
  m_entityMap[254]="thorn";
  m_entityMap[255]="yuml";
}

string Entities::Escape(const string& data){
  if(!m_filled) InitEntities();
  string newData;
  for(string::const_iterator i=data.begin();i!=data.end();++i){
    map<char,string>::const_iterator pos=m_entityMap.find(*i);
    if(pos==m_entityMap.end()){
      newData+=*i;
    }else{
      newData+="&"+pos->second+";";
    }
  }
  return newData;  
}

string Entities::Unescape(const string& data){
  if(!m_filled) InitEntities();
  string newData;
  for(string::const_iterator i=data.begin();i!=data.end();++i){
    if(*i=='&'){
      string::const_iterator j=i;
      int offset=0;
      for(;j!=data.end();++j){
        if(*j==';'){++j; offset=1; break;}
        if(*j==' ') break;
      }
      string entity(i+1,j-offset);
      bool done=false;
      for(map<char,string>::const_iterator k=m_entityMap.begin();
        (k!=m_entityMap.end())&&!done;++k){
        if(entity==k->second){
          newData+=k->first;
          done=true;
        }
      }
      if(!done){
        if(entity[0]=='#'){
          int pos=1;
          int base=10;
          if((entity[pos]=='x')||(entity[pos]=='X')){
            ++pos;
            base=16;
          }
          int val=strtol(entity.data()+pos,NULL,base);
          newData+=char(val);
        }else{
          newData+="&"+entity+";";
        }
      }
      i=j-1;
    }else{
      newData+=*i;
    }
  }
  return newData;
}
