/****************************************************************************
 *                           StimulusItem.h
 *
 * Author: Matthew Ballance
 * Desc:   The StimulusItem class describes an event in a sequence. The event
 *         may be a single value change or a sequence of value changes...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STIMULUS_ITEM_H
#define INCLUDED_STIMULUS_ITEM_H
#include "types.h"

class BitVector;
class StimulusSeq;
class StimulusItem {
    public:
        StimulusItem(BitVector *val, Uint32 del);
        StimulusItem(StimulusSeq *seq, Uint32 del);

        inline Uint32 is_sequence() const { return (sequence)?1:0; }
        inline Uint32 is_value() const   { return (value)?1:0; }

        inline void set_delay(Uint32 del) { delay = del;     }
        inline Uint32 get_delay() const   { return delay;    }

        inline BitVector   *get_value()   { return value;    }
        inline StimulusSeq *get_seq()     { return sequence; }

    private:
        BitVector     *value;
        StimulusSeq   *sequence;

        Uint32       delay;
};

#endif /* INCLUDED_STIMULUS_ITEM_H */
