/*****************************************************************************
 *                            TclInterpObj.cc
 *
 * Author: Matthew Ballance
 * Desc:   Wrapper around a TCL interp
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#include "TclInterpObj.h"

/********************************************************************
 * TclInterpObj()
 ********************************************************************/
TclInterpObj::TclInterpObj(Tcl_Interp *interp)
{
    d_interp = interp;
}

/********************************************************************
 * ~TclInterpObj()
 *
 * Set the interp-result if any result has been set...
 ********************************************************************/
TclInterpObj::~TclInterpObj(void)
{

}

/********************************************************************
 * operator << TclInterpObj
 *
 * Copies status from one obj to another..
 ********************************************************************/
void TclInterpObj::operator << (TclInterpObj &rhs)
{
    Tcl_SetObjResult(d_interp,
            Tcl_DuplicateObj(Tcl_GetObjResult(rhs.d_interp)));
}

/********************************************************************
 * operator << Tcl_Obj
 *
 * Sets command result on interp...
 ********************************************************************/
void TclInterpObj::operator << (Tcl_Obj *rhs)
{
    Tcl_SetObjResult(d_interp, rhs);
}

/********************************************************************
 * operator () Tcl_Interp
 ********************************************************************/
void TclInterpObj::operator() (Tcl_Interp *interp)
{
    d_interp = interp;
}

/********************************************************************
 * eval(Tcl_Obj)
 ********************************************************************/
int TclInterpObj::eval(Tcl_Obj *cmd)
{
    return Tcl_EvalObjEx(d_interp, cmd, TCL_EVAL_GLOBAL);
}



