#****************************************************************************
#*                             TitleFrame.tcl
#*
#* Author: Matthew Ballance
#* Desc:   TCL file to create labled frames.
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

package provide ivi_common "1.0"

namespace eval TitleFrame {
    namespace export TitleFrame
}

proc TitleFrame::TitleFrame {path args} {

    set side     "left"
    set text     ""
    set baseline "center"
    set bd 2
    set pad 2
    set relief groove

    while {[llength $args] > 0} {
        set shift 1
        set arg [lindex $args 0]
        if {$arg == "-text"} {
            set shift 2
            set text  [lindex $args 1]
        } elseif {$arg == "-side"} {
            set shift 2
            set side [lindex $args 1]
        } elseif {$arg == "-baseline"} {
            set shift 2
            set side [lindex $args 1]
        } elseif {$arg == "-bd"} {
            set shift 2
            set bd [lindex $args 1]
        } elseif {$arg == "-pad"} {
            set shift 2
            set pad [lindex $args 1]
        } elseif {$arg == "-relief"} {
            set shift 2
            set relief [lindex $args 1]
        } else {
            puts "error :: unknown option \"$arg\""
        }
        set args [lrange $args $shift end]
    }
    
    array set $path {_dummy other}
    upvar #0 $path data

    set frame [frame $path -relief $relief -bd 0 -highlightthickness 0]

    set padtop [frame $path.p -relief flat -borderwidth 0]
    set border [frame $path.b -highlightthickness 0 -borderwidth 2 \
        -relief $relief]
    if {$text != ""} {
        set label  [label $path.l -highlightthickness 0 -relief flat -bd 0 \
                -padx 2 -pady 0 -text $text]
    }
    set padbot [frame $border.p -relief $relief -bd 0 -highlightthickness 0]
    set frame  [frame $path.f -relief $relief -bd 0 -highlightthickness 0]

    if {$text != ""} {
        set height [winfo reqheight $label]
    } else {
        set height 2
    }

    switch $side {
        left   { set relx 0.0; set x 5; set anchor nw  }
        center { set relx 0.5; set x 0; set anchor n   }
        right  { set relx 1.0; set x -5; set anchor ne }
    }

    switch $baseline {
        top    { set htop $height ; set hbot 1 ; set y 0}
        center { set htop [expr {$height/2}]; set hbot [expr {$height/2+$height%2+1}]; set y 0 }
        bottom {set htop 1; set hbot $height; set y [expr {$bd+1}] }
    }

    $padbot config -height $htop
    $padbot config -height $hbot


    pack $padbot -side top -fill x
    pack $frame  -in $border -fill both -expand yes -padx $pad -pady $pad
    pack $padtop -side top -fill x
    pack $border -fill both -expand yes

    if {$text != ""} {
        place $label -relx $relx -x $x -anchor $anchor -y $y
        bind $label <Configure> "TitleFrame::prv_place $path"
    }

    set data(side) $side
    set data(bd) $bd
    set data(baseline) $baseline

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval TitleFrame::\$cmd $path \$args\]"

    return $path
}

proc TitleFrame::getframe { path } {
    return $path.f
}

proc TitleFrame::prv_place {path} {
    upvar #0 $path data

    set side $data(side)
    set bd   $data(bd)

    set height [winfo height $path.l]

    switch $side {
        left    {set relx 0.0; set x 10; set anchor nw }
        center  {set relx 0.5; set x  0; set anchor n  }
        right   {set relx 1.0; set x -10; set anchor ne }
    }

    switch $data(baseline) {
        top    {set htop $height; set hbot 1; set y 0}
        center {set htop [expr {$height/2}]; \
            set hbot [expr {$height/2+$height%2+1}]; set y 0}
        bottom {set htop 1; set hbot $height; set y [expr {$bd+1}] }
    }

    $path.p config -height $htop
    $path.b.p config -height $hbot

    place $path.l -relx $relx -x $x -anchor $anchor -y $y
}


# set tf [TitleFrame::TitleFrame .m ]
# set tff [$tf getframe]
# set inner [button $tff.n -text "Hello 2"]
# pack $inner -expand yes -fill both
# pack $tf -padx 2 -pady 2


