#****************************************************************************
#*                            ModuleLoader.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements a module loader for IVI. This module scans the module
#*         directory of IVI_HOME and loads and initializes the modules 
#*         located in sub-dirs of this directory.
#*
#*
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#*
#*
#****************************************************************************

namespace eval ModuleLoader {
    namespace export ModuleLoader 
    variable  ivi_modules ""
    variable  dir
}

#**********************************************************
#* setup_modpath
#**********************************************************
proc ModuleLoader::setup_modpath {mod_dir} {
    set modpath ""

    foreach node [glob [file join $mod_dir *]] {
        if {[file isdirectory $node]} {
            lappend modpath $node
        }
    }
    return $modpath
}

#**********************************************************
#* load_configs
#**********************************************************
proc ModuleLoader::load_configs {module_dirs} {

    foreach dir [glob -type d [file join $module_dirs *]] {
        if {![catch {set configs [glob [file join $dir "*.conf"]]} res]} {
            foreach config $configs {
                IviConfig::load $config -level system
            }
        }
    }
}

#**********************************************************
#* package
#**********************************************************
proc ModuleLoader::pcakage args {
    variable dir
    puts "::package"

    set pkg [lindex $args 2]
    if {[catch {::package present $pkg} res]} {
        eval [lindex $args end]
        if {[info commands "${pkg_name}_Init"] != ""} {
            if {[catch {"${pkg_name}_Init"} err]} {
                ivi_puts "ERROR: cannot initialize $pkg_name ($err)"
            }
        }
    } else {
        puts "package \"$pkg\" already loaded"
    }
}

#**********************************************************
#* 
#**********************************************************

#**********************************************************
#* init_modules
#**********************************************************
proc ModuleLoader::init_modules {mod_path} {
    global   auto_path
    global dir

    foreach pkg [glob -type d [file join $mod_path *]] {
        if {[file exists [file join $pkg pkgIndex.tcl]]} {
            set dir $pkg
            set pkg_name [lindex [file split $pkg] end]
#            if {[catch {package present $pkg_name} res]} 
            if {$pkg_name != "ivi_ui" && $pkg_name != "ivi_common"} {
                puts "NOTE: Loaded package \"$pkg_name\""
                set file [file join $pkg pkgIndex.tcl]
                regsub { } $file {\\ } file
                if {[catch {uplevel #0 source "$file"} res]} {
                    puts "ERROR: sourcing $file"
                    puts "   $res"
                }
                if {[info commands "${pkg_name}_Init"] != ""} {
                    if {[catch {"${pkg_name}_Init"} err]} {
                        puts "ERROR: cannot initialize $pkg_name ($err)"
                    }
                }
            }
        }
    }
}


proc ModuleLoader::ModuleLoader {mod_dir} {
#    set modpath [ModuleLoader::setup_modpath $mod_dir]

    ModuleLoader::init_modules $mod_dir

    ModuleLoader::load_configs $mod_dir
}


