/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-thumbnail.h"

#include <string.h>
#include <glib/gi18n.h>
#include "gobject-utils.h"
#include "gtk-utils.h"
#include "egg-pixbuf-thumbnail.h"

/* object class */
static void kz_thumbnail_class_init     (KzThumbnailClass *klass);
static void kz_thumbnail_init           (KzThumbnail      *kzthumbnail);

static KzInputEventBoxClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_thumbnail, "KzThumbnail", KzThumbnail,
		   kz_thumbnail_class_init, kz_thumbnail_init,
		   KZ_TYPE_INPUT_EVENT_BOX)

static void
kz_thumbnail_class_init (KzThumbnailClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;
}


static void
kz_thumbnail_init (KzThumbnail *thumbnail)
{
	thumbnail->image = gtk_image_new();
	gtk_container_add(GTK_CONTAINER(thumbnail), thumbnail->image);
	gtk_widget_show(thumbnail->image);
}


GtkWidget *
kz_thumbnail_new (void)
{
	KzThumbnail *thumbnail;

	thumbnail = g_object_new (KZ_TYPE_THUMBNAIL, NULL);

	return GTK_WIDGET (thumbnail);
}


void
kz_thumbnail_set_pixbuf (KzThumbnail *thumbnail, GdkPixbuf *pixbuf)
{
	gtk_image_set_from_pixbuf (GTK_IMAGE(thumbnail->image), pixbuf);
}

void
kz_thumbnail_set_thumbnail_from_uri (KzThumbnail *thumbnail, 
				     const gchar *uri)
{
	GdkPixbuf *pixbuf = NULL;
	gchar *filename;

	if (uri && strlen(uri))
	{
		filename = egg_pixbuf_get_thumb_filename(uri, 
							 EGG_PIXBUF_THUMB_LARGE);
		pixbuf = egg_pixbuf_get_thumbnail_for_file(filename,
							   EGG_PIXBUF_THUMB_NORMAL,
							   NULL);
		g_free(filename);
	}

	if (!pixbuf) /* dummy pixbuf */
	{
		GdkPixbuf *dummy;
		dummy = gdk_pixbuf_new_from_file(KZ_DATADIR"/kz-no-thumbnail.png",
						 NULL);
		pixbuf = egg_pixbuf_create_thumbnail(dummy,
						     "no_thumbnail",
						     0,
						     EGG_PIXBUF_THUMB_NORMAL);
		g_object_unref(dummy);
	}

	gtk_image_set_from_pixbuf (GTK_IMAGE(thumbnail->image), pixbuf);
	g_object_unref(pixbuf);
}

