/***************************************************************************
                          csvimportdlg.h  -  description
                             -------------------
    begin                : Don Aug 21 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVIMPORTDLG_H
#define CSVIMPORTDLG_H

#include <qwidget.h>
#include <kdialogbase.h>

class KComboBox;
class KIntNumInput;
class KPushButton;
class KURLRequester;
class QFrame;
class QTable;
/** Import a CSV (comma separated value) file into
  * a SQL table. CSV files can be generated by almost
  * any spreadsheet application.
  * This dialog is also available as a separate application
  * KESI ( http://kesi.sf.net ).
  * This class makes importing data in KBarcode very easy
  * for the user.
  *
  * @author Dominik Seichter
  */
class CSVImportDlg : public KDialogBase  {
    Q_OBJECT
    public: 
        CSVImportDlg(QWidget *parent=0, const char *name=0);
        ~CSVImportDlg();

    private slots:
        void settingsChanged();
        void setCol();
        void updateFields();
        void updateCol( int c );

        void enableControls();
        
    private:
        KComboBox* comboSQL;
        KComboBox* comboField;
        KIntNumInput* spinCol;
        KPushButton* buttonSet;
        KURLRequester* requester;
        QFrame* frame;
        QTable* table;

    protected slots:
        void accept();
};

#endif
