/***************************************************************************
                          xmlutils.h  -  description
                             -------------------
    begin                : Mit Mai 7 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLUTILS_H
#define XMLUTILS_H

#include "mybarcode.h"
#include <qmap.h>

class CanvasBarcode;
class Definition;
class MyCanvasView;
class QColor;
class QDomElement;
class QRect;
class QString;
class QWidget;

/** This class provides helper function for saving and reading to XML files.
  *
  * @author Dominik Seichter
  */
class XMLUtils {
    public: 
        XMLUtils();
        ~XMLUtils();

        void writeXMLColor( QDomElement* tag, const QString & prefix, QColor c ) const;
        QColor readXMLColor( QDomElement* tag, const QString & prefix, QColor c );

        void writeXMLRect( QDomElement* tag, QRect r, MyCanvasView* cv = 0 ) const;
        QRect readXMLRect( QDomElement* tag, MyCanvasView* cv = 0 );

        void writeDefinition( QDomElement* tag, Definition* d ) const;
        Definition* readDefinition( QDomElement* tag, QWidget* parent = 0 );

        void writeBarcode( QDomElement* tag, const barcodeData* data, const CanvasBarcode* code = 0, const MyCanvasView* cv = 0, bool cache = false ) const; 
        barcodeData readBarcode( QDomElement* tag, MyCanvasView* cv = 0 );

    private:
        static QMap<QString,QString> legacy;
};

#endif
