/***************************************************************************
                          zplutils.h  -  description
                             -------------------
    begin                : Son Okt 12 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZPLUTILS_H
#define ZPLUTILS_H

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>

class QColor;
class QImage;
class QPaintDevice;
class QSize;
class QTextStream;

/** A base class that provides an interface for the LabelEditor
  * to export labels to various barcode printer which all use
  * their own propieritary formats.
  *
  *@author Dominik Seichter  
  */
class ExportUtils {
    public:
        ExportUtils( QTextStream* stream, QPaintDevice* source );

        virtual void setTextField( int x, int y, const QString & text ) = 0;
        virtual void setBarcode( int x, int y, int h, const QString & value, const QString & type ) = 0;
        virtual void setRect( int x, int y, const QSize size, bool circle, int width ) = 0;        
        virtual void setImage( int x, int y, const QImage* image ) = 0;
        virtual void close() = 0;
                
    protected:
        /** Convert x pixels from screen to
          * destination printer resolution.
          */
        int convertX( int x );
        /** Convert y pixels from screen to
          * destination printer resolution.
          */
        int convertY( int y );
        /** Set the resolution of the destination printer
          */
        void setResolution( const int r ) {
            res = r;
        }

        QTextStream* t;
        QPaintDevice* src;

    private:
        int res;
};

/**
  * This class provides functions
  * to convert KBarcode label data
  * into Zebra Printer Language.
  *
  *@author Dominik Seichter
  */
class ZPLUtils : public ExportUtils {
    public: 
        ZPLUtils( QTextStream* stream, QPaintDevice* source );

        void setTextField( int x, int y, const QString & text );
        void setBarcode( int x, int y, int h, const QString & value, const QString & type );
        void setRect( int x, int y, const QSize size, bool circle, int width );
        void setImage( int x, int y, const QImage* image );
        
        void close();

    private:
        /** fill the map to match kbarcode encoding types with ZPL types */
        void fillEncodings();

        void setEllipse( const QSize & size, int thick );
        void setFieldData( const QString & data );
        void setFieldOrigin( int x, int y );
        void setFont( QString font = QString::null );
        void setRectangle( const QSize & size, int thick );

    protected:
        static QMap<QString,QString> encodings;
};

/**
  * This class provides functions
  * to convert KBarcode label data
  * into Intermec printer language.
  *
  * Thanks to Erich Kitzmller for providing
  * me with information and an examplefor this stuff.
  *@author Dominik Seichter
  */
class IPLUtils : public ExportUtils {
    public:
        IPLUtils( QTextStream* stream, QPaintDevice* source );
        virtual ~IPLUtils() { };

        void setTextField( int x, int y, const QString & text );
        void setBarcode( int x, int y, int h, const QString & value, const QString & type );
        void setRect( int x, int y, const QSize size, bool circle, int width );
        void setImage( int x, int y, const QImage* image ); 
        
        void close();

    private:
        /** fill the map to match kbarcode encoding types with IPL types */
        void fillEncodings();

        /** Sets the field origin for the given rotation
          */
        QString setFieldOrigin( int x, int y );
    
        inline void setField( const QString & data );
    
        int counter;
        QStringList values;
        static QMap<QString,QString> encodings;
};

#endif
