/***************************************************************************
                          kbearcopyjob.h  -  description
                             -------------------
    begin                : fre maj 10 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCOPYJOB_H
#define KBEARCOPYJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
//////////////////////////////////////////////////////////////////////
// application specific include files


class Transfer;

class KBearCopyJob : public KIO::Job {
	Q_OBJECT
public:
	enum CopyMode{ Copy, Move, Link };
	KBearCopyJob( Transfer* , CopyMode mode, bool asMethod );

	KURL::List srcURLs() const { return m_srcList; }
	KURL destURL() const { return m_dest; }
	static KBearCopyJob* copy( Transfer* );
	static KBearCopyJob* move( Transfer* );
	bool localSrc() { return m_srcIsLocal; }
	bool localDest() { return m_destIsLocal; }
	void setOverwriteAll( bool o=true ) { m_bOverwriteAll = o; }

public slots:
	void slotStart();
signals:

	void totalFiles( KIO::Job *, unsigned long files );
	void totalDirs( KIO::Job *, unsigned long dirs );

	void processedFiles( KIO::Job *, unsigned long files );
	void processedDirs( KIO::Job *, unsigned long dirs );

	/**
	* The job is copying a file or directory
	*/
	void copying( KIO::Job *, const KURL& from, const KURL& to );
	/**
	* The job is creating a symbolic link
	*/
	void linking( KIO::Job *, const QString& target, const KURL& to );
	/**
	* The job is moving a file or directory
	*/
	void moving( KIO::Job *, const KURL& from, const KURL& to );
	/**
	* The job is creating the directory @p dir
	*/
	void creatingDir( KIO::Job *, const KURL& dir );
	/**
	* The user chose to rename 'from' to 'to'
	*/
	void renamed( KIO::Job *, const KURL& from, const KURL& to );

	/**
	* The job emits this signal when copying or moving a file or directory successfully finished.
	* @param src the source URL
	* @param dst the destination URL
	* @param direction indicates whether a file or directory was successfully copied/moved
	* @param renamed indicates that the destination URL was created using a
	* rename operation (i.e. fast directory moving).
	* This signal is mainly for the Undo feature.
	*/
	void copyingDone( KIO::Job *, const KURL &from, const KURL &to, bool directory, bool renamed );
	/**
	* The job is copying or moving a symbolic link, that points to target.
	* The new link is created in @p to. The existing one is/was in @p from.
	* This signal is mainly for the Undo feature.
	*/
	void copyingLinkDone( KIO::Job *, const KURL &from, const QString& target, const KURL& to );
	void logMessage( const QString&, const QString& );
protected:
	void statNextSrc();

	// Those aren't slots but submethods for slotResult.
	void slotResultStating( KIO::Job * job );
	void startListing( const KURL & src );
	void slotResultCreatingDirs( KIO::Job * job );
	void slotResultConflictCreatingDirs( KIO::Job * job );
	void createNextDir();
	void slotResultCopyingFiles( KIO::Job * job );
	void slotResultConflictCopyingFiles( KIO::Job * job );
	void copyNextFile();
	void slotResultDeletingDirs( KIO::Job * job );
	void deleteNextDir();
	void skip( const KURL & sourceURL );

protected slots:
	void slotEntries( KIO::Job*, const KIO::UDSEntryList& list );
	virtual void slotResult( KIO::Job *job );
	/**
	* Forward signal from subjob
	*/
	void slotProcessedSize( KIO::Job*, KIO::filesize_t data_size );
	/**
	* Forward signal from subjob
	*/
	void slotTotalSize( KIO::Job*, KIO::filesize_t size );

	void slotReport();
	void slotDestInfoMessage( KIO::Job*, const QString& );
	void slotSourceInfoMessage( KIO::Job*, const QString& );
private:
	struct CopyInfo {
		KURL uSource;
		KURL uDest;
		QString linkDest; // for symlinks only
		int permissions;
		//mode_t type;
		time_t ctime;
		time_t mtime;
		off_t size; // 0 for dirs
	};
	CopyMode m_mode;
	bool m_asMethod;
	enum { DEST_NOT_STATED, DEST_IS_DIR, DEST_IS_FILE, DEST_DOESNT_EXIST } destinationState;
	enum { STATE_STATING, STATE_RENAMING, STATE_LISTING, STATE_CREATING_DIRS,
		STATE_CONFLICT_CREATING_DIRS, STATE_COPYING_FILES, STATE_CONFLICT_COPYING_FILES,
		STATE_DELETING_DIRS
	} state;
	KIO::filesize_t m_totalSize;
	KIO::filesize_t m_processedSize;
	KIO::filesize_t m_fileProcessedSize;
	int m_processedFiles;
	int m_processedDirs;
	QValueList<CopyInfo> files;
	QValueList<CopyInfo> dirs;
	KURL::List dirsToRemove;
	KURL::List m_srcList;
	KURL::List::Iterator m_currentStatSrc;
	bool m_bCurrentSrcIsDir;
	bool m_bCurrentOperationIsLink;
	bool m_bSingleFileCopy;
	bool m_bOnlyRenames;
	KURL m_dest;
	KURL m_currentDest;
	//
	QStringList m_skipList;
	QStringList m_overwriteList;
	bool m_bAutoSkip;
	bool m_bOverwriteAll;
	int m_conflictError;

	QTimer *m_reportTimer;
	//these both are used for progress dialog reporting
	KURL m_currentSrcURL;
	KURL m_currentDestURL;
	Transfer* m_transfer;
	bool m_srcIsLocal;
	bool m_destIsLocal;
	unsigned long m_ID;
};

#endif
