/***************************************************************************
                          kbearlogview.cpp  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//////////////////////////////////////////////////////
// Qt specific includes
#include <qtextcodec.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
#include <kglobal.h>
#include <kcharsets.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearlogview.h"
#include "kbearmdichildview.h"


//-----------------------------------------------
KBearLogView::KBearLogView(QWidget *parent, const QString& name )
	: KBearTabView( parent, name.latin1() )
{
}
//-----------------------------------------------
KBearLogView::~KBearLogView(){
}
//-----------------------------------------------
void KBearLogView::setEncoding( const QString& encoding ) {
	bool ok;
	m_codec = KGlobal::charsets()->codecForName( encoding, ok );
}
//-----------------------------------------------
void KBearLogView::slotLogMessage( const QString& name, const QString& message ){
	int tabNr = findTabByCaption( name );
	if( tabNr == -1 ) {
		return;
	}
 	
	KBearTextEdit* tEdit = static_cast<KBearTextEdit*>( page( tabNr ) );
	QString tmp;
/*
	if( message.left(4) == "resp" ) {
		tmp = QString("<font color=\"darkred\">%1</font>").arg( message.mid( 5, message.length() )+'\n' );
	}
	else if( message.left(7) == "command" ) {
		tmp = QString("<font color=\"darkblue\">%1</font>").arg( message.mid( 8, message.length() )+'\n' );
	}
	else if( message.left(10) == "multi-line" ) {
		tmp = QString("<font color=\"darkgreen\">%1</font>").arg( message.mid( 11, message.length() )+'\n' );
	}
	else if( message.left(8) == "internal" ) {
		tmp = QString("%1").arg( message.mid( 8, message.length() )+'\n' );
	}
	else {
		tmp = QString("%1").arg(message+'\n');
	}
*/
 	if( message.left(4) == "resp" ) {
		tEdit->setColor( "darkred" );
		tmp = message.mid( 5, message.length() );
		tmp = m_codec?m_codec->toUnicode( tmp ):tmp;
	}
	else if( message.left(7) == "command" ) {
		tEdit->setColor( "darkblue" );
		tmp = message.mid( 8, message.length() );
		tmp = m_codec?m_codec->toUnicode( tmp ):tmp;
	}
	else if( message.left(10) == "multi-line" ) {
		tEdit->setColor( "darkgreen" );
		tmp = message.mid( 11, message.length() );
		tmp = m_codec?m_codec->toUnicode( tmp ):tmp;
	}
	else if( message.left(8) == "internal" ) {
		tEdit->setColor( "black" );
		tmp = message.mid( 8, message.length() );
		tmp = m_codec?m_codec->toUnicode( tmp ):tmp;
	}
	else {
		tEdit->setColor( "black" );
		tmp = message;
	}

	if( tmp.right( 1 ) == "\r" )
		tmp = tmp.left( tmp.length() );
	else if( tmp.right( 2 ) == "\r\n" )
		tmp = tmp.left( tmp.length() - 2 );
	if( tmp.right( 1 ) != "\n" )
		tmp += "\n";
	tEdit->append( tmp );
	tEdit->scrollToBottom();
}
//-----------------------------------------------
void KBearLogView::addPage( const QString& name ){
	KBearTabView::addPage( name );
	KBearTextEdit* w = new KBearTextEdit( this, name );
	w->setReadOnly( true );
	addTab( w, name );
	showPage( w );
}
//-----------------------------------------------
void KBearLogView::slotSetActiveLogTab(QextMdiChildView* view) {
	int tabNr = findTabByCaption( static_cast<KBearMdiChildView*>(view)->connection().label() );
	if( tabNr == -1 )
		return;

	QWidget* tab = page(tabNr);
	QTabWidget::showPage(tab);
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearlogview.moc"
#endif
