/***************************************************************************
                          dirsynchconfigdialog.cpp  -  description
                             -------------------
    begin                : fre okt 25 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvaluelist.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kcolorbutton.h>
#include <knuminput.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "dirsynchconfigdialog.h"
#include "dirsynchpartconfigbase.h"

//-----------------------------------------------
DirSynchConfigDialog::DirSynchConfigDialog(QWidget *parent, const char *name, const QString& label )
	:	KDialogBase( parent, name, true, i18n("Configure Directory Synchronizing"),
		(KDialogBase::Help | KDialogBase::Default | KDialogBase::Ok | KDialogBase::Cancel), KDialogBase::Ok ),
		m_label( label ), m_config( new KConfig( "kbeardirsynchpartrc", false, false ) )
{
	m_widget = new DirSynchPartConfigBase( this, "KBearToolsWidget" );
	setMainWidget( m_widget );
	readConfig();
	connect( this, SIGNAL( helpClicked() ), this, SLOT( slotHelpClicked() ) );
	connect( this, SIGNAL( defaultClicked() ), this, SLOT( slotDefaultClicked() ) );
}
//-----------------------------------------------
DirSynchConfigDialog::~DirSynchConfigDialog() {
	delete m_config;
}
//-----------------------------------------------
void DirSynchConfigDialog::slotOk() {
	saveConfig();
	KDialogBase::slotOk();
}
//-----------------------------------------------
void DirSynchConfigDialog::readConfig() {
	readGroup( m_label );
}
//-----------------------------------------------
void DirSynchConfigDialog::readGroup( const QString& group ) {
	if( m_config->hasGroup( group ) ) {
		m_config->setGroup( group );
		QValueList<int> colList = m_config->readIntListEntry( "Diff Color" );
		if( colList.size() > 2 )
			m_widget->m_diffColorButton->setColor( QColor(colList[ 0 ], colList[ 1 ], colList[ 2 ] ) );

		colList = m_config->readIntListEntry( "Missing Remote" );
		if( colList.size() > 2 )
			m_widget->m_missingRemoteColorButton->setColor( QColor(colList[ 0 ], colList[ 1 ], colList[ 2 ] ) );

		colList = m_config->readIntListEntry( "Missing Local" );
		if( colList.size() > 2 )
			m_widget->m_missingLocalColorButton->setColor( QColor(colList[ 0 ], colList[ 1 ], colList[ 2 ] ) );

		m_widget->m_deleteWarningCheckBox->setChecked( m_config->readBoolEntry( "Confirm Delete", true ) );
		m_widget->m_timeDifferenceNumInput->setValue( m_config->readNumEntry( "Time Diff", 0 ) );
		if( m_config->readUnsignedNumEntry( "Diff Type", 1 ) == 0 )
			m_widget->m_useTimeDiffRadioButton->setChecked( true );
		else
			m_widget->m_sizePermDiffRadioButton->setChecked( true );

	}
}
//-----------------------------------------------
void DirSynchConfigDialog::saveConfig() {
	if( m_widget->m_globalCheckBox->isChecked() ) {
		QStringList groups = m_config->groupList();
		for( unsigned int i = 0; i < groups.count(); i++ ) {
			if( groups[ i ] != "DirSynchDefault" )
				saveGroup( groups[ i ] );
		}
	}
	else
		saveGroup( m_label );
}
//-----------------------------------------------
void DirSynchConfigDialog::saveGroup( const QString& group ) {
	kdDebug()<<"DirSynchConfigDialog::saveGroup saving group="<<group<<endl;
	m_config->setGroup( group );
	QValueList<int> colList;
	colList.append( m_widget->m_diffColorButton->color().red() );
	colList.append( m_widget->m_diffColorButton->color().green() );
	colList.append( m_widget->m_diffColorButton->color().blue() );
	m_config->writeEntry( "Diff Color", colList );

	colList.clear();
	colList.append( m_widget->m_missingRemoteColorButton->color().red() );
	colList.append( m_widget->m_missingRemoteColorButton->color().green() );
	colList.append( m_widget->m_missingRemoteColorButton->color().blue() );
	m_config->writeEntry( "Missing Remote", colList );

	colList.clear();
	colList.append( m_widget->m_missingLocalColorButton->color().red() );
	colList.append( m_widget->m_missingLocalColorButton->color().green() );
	colList.append( m_widget->m_missingLocalColorButton->color().blue() );
	m_config->writeEntry( "Missing Local", colList );

	m_config->writeEntry( "Confirm Delete", m_widget->m_deleteWarningCheckBox->isChecked() );
	m_config->writeEntry( "Time Diff", m_widget->m_timeDifferenceNumInput->value() );

	if( m_widget->m_useTimeDiffRadioButton->isChecked() )
		m_config->writeEntry( "Diff Type", 0 );
	else
		m_config->writeEntry( "Diff Type", 1 );

	m_config->sync();
}
//-----------------------------------------------
void DirSynchConfigDialog::slotHelpClicked() {
}
//-----------------------------------------------
void DirSynchConfigDialog::slotDefaultClicked() {
	readGroup( "DirSynchDefault" );
}
//-----------------------------------------------
