/***************************************************************************
                          kbeardetailview.cpp  -  description
                             -------------------
    begin                : lr jan 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtextcodec.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kcharsets.h>
#include <kfile.h>
#include <kiconloader.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardetailview.h"


//-----------------------------------------------
KBearDetailView::KBearDetailView(QWidget *parent, const char *name, const Connection& c )
	:	KFileDnDDetailView(parent,name), m_connection( c )
{
	setViewMode( KFileView::All );
	readConfig( kapp->config(), "View Settings" );
	setSelectionMode( KFile::Extended );
//	setFocusPolicy( QWidget::WheelFocus );
	bool ok;
	m_codec = KGlobal::charsets()->codecForName( m_connection.fileSysEncoding(), ok );
}
//-----------------------------------------------
KBearDetailView::~KBearDetailView(){
}
//-----------------------------------------------
void KBearDetailView::insertItem( KFileItem* i ) {
/*
	KURL url( i->url().url(), m_codec->mibEnum() );
	i->setURL( url );
	kdDebug()<<"KBearDetailView::insertItem file encoding="<<i->url().fileEncoding()<<" =="<<m_connection.fileSysEncoding()<<endl;
*/
	KFileDetailView::insertItem( i );

	KFileListViewItem *item = (KFileListViewItem*) i->extraData( this );
	if( m_connection.isLocal() )
		item->setText( 0, i->text() );
	else
		item->setText( 0, m_codec->toUnicode( i->text() ) );
}
//-----------------------------------------------
void KBearDetailView::startDrag(){
	// create a list of the URL:s that we want to drag
	KURL::List urls;
	KFileItemListIterator it( * KFileView::selectedItems() );
	for ( ; it.current(); ++it ){
		urls.append( (*it)->url() );
	}
	QPixmap pixmap;
	if( urls.count() > 1 ){
		pixmap = DesktopIcon( "kmultiple", 16 );
	}
	if( pixmap.isNull() )
		pixmap = currentFileItem()->pixmap( 16 );	
	QPoint hotspot;
	hotspot.setX( pixmap.width() / 2 );
	hotspot.setY( pixmap.height() / 2 );
	m_dragObject = KURLDrag::newDrag( urls, m_connection.metaData(), widget() );
	m_dragObject->metaData().insert( "sourceName", m_connection.label().utf8() );

	m_dragObject->setPixmap( pixmap, hotspot );
	m_dragObject->drag();   // start the drag
}
//-----------------------------------------------
void KBearDetailView::updateView( const KFileItem* inf ) {
	if( !inf )
		return;

/*
	KFileItem* i = (KFileItem*)inf;
	KURL url( i->url() );
	url.setEncodedPath( m_codec->toUnicode( url.path() ), m_codec->mibEnum() );
	i->setURL( url );
	kdDebug()<<"KBearDetailView::updateView file encoding="<<i->url().fileEncoding()<<" =="<<m_connection.fileSysEncoding()<<endl;
*/
	KFileDetailView::updateView( inf );
	KFileListViewItem *item = (KFileListViewItem*) inf->extraData( this );
	if( !item )
		return;

	if( m_connection.isLocal() )
		item->setText( 0, inf->text() );
	else
		item->setText( 0, m_codec->toUnicode( inf->text() ) );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeardetailview.moc"
#endif
