/* -*- C++ -*-

   This file declares the KVaio module for KMilo.

   $ Author: Mirko Boehm $
   $ Copyright: (C) 1996-2003, Mirko Boehm $
   $ Contact: mirko@kde.org
         http://www.kde.org
         http://www.hackerbuero.org $
   $ License: LGPL with the following explicit clarification:
         This code may be linked against any version of the Qt toolkit
         from Troll Tech, Norway. $

   $Id: kmilo_kvaio.h,v 1.3 2004/01/08 01:48:18 mirko Exp $

   * Portions of this code are
   * (C) 2001-2002 Stelian Pop <stelian@popies.net> and
   * (C) 2001-2002 Alcove <www.alcove.com>.
   * Thanks to Stelian for the implementation of the sonypi driver.
*/

#ifndef _KMILO_KVAIO_H_
#define _KMILO_KVAIO_H_

#include <monitor.h>

class KVaio;

class KMiloKVaio : public KMilo::Monitor {
	public:
		KMiloKVaio(QObject *parent, 
			   const char *name, const QStringList&);
		virtual ~KMiloKVaio();

		virtual bool init();
		virtual DisplayType poll();
		virtual int progress() const;

		virtual void reconfigure(KConfig*);
	private:
		KVaio *m_kvaio;
};

#endif
