/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KDISSERTVIEW_H
#define _KDISSERTVIEW_H

#include <kmdichildview.h>
#include <kmdichildfrm.h>

class KDissertPart;

/**
 * This class serves as the kdissert view.
 *
 * @short main view class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.3
 */
class KDissertView : public KMdiChildView 
{
    Q_OBJECT
    public:
	KDissertView( QWidget *parentWidget=0L, const char *name=0L );
	virtual ~KDissertView();

	KDissertPart *part();

    private:
	KDissertPart *m_part;
    
    public slots:
	void updateCaption();
};

#endif // _KDISSERTVIEW_H

