/***************************************************************************
                          kfocusdialogcompletetask.h  -  description
                             -------------------
    begin                : Sun Aug 26 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSDIALOGCOMPLETETASK_H
#define KFOCUSDIALOGCOMPLETETASK_H

#include <qwidget.h>
#include <kdialog.h>
class QCheckBox;
class QLayout;

class KFVTask;
class KFVLog;

class KFMTask;
class KFMLog;

/**Dialog used when the user completes a task
  *@author Jeffrey Yu
  */

class KFDCompleteTask : public KDialog  {
   Q_OBJECT
public: 
	KFDCompleteTask(int tasksRemaining, QWidget *parent=0, const char *name=0);
	~KFDCompleteTask();
	
	/** Specify the completed task to the dialog so it can initialize the followup task */
	void completedTask(KFMTask* task);
	
	/** Query the followup task that was defined in the dialog */
	KFMTask* followupTask() const;
	
	/** Query the log that was defined in the dialog */
	KFMLog* log() const;
	
protected:
	/** Override base class to add special handling of accept() */
	virtual void accept();
	
private:
	void createWidgets(int tasksRemaining);
	void createLeftWidgets(QLayout* lParent, int tasksRemaining);
	void createLogWidgets(QLayout* lParent);
	
private slots:
	void onCbFollowupToggled(bool on);
	void onCbLogToggled(bool on);
	
private:
	QCheckBox* cbFollowup_;
	KFVTask* vTaskProps_;
	
	QCheckBox* cbLog_;
	KFVLog* vLog_;
	
	KFMTask* task_;
	KFMLog* log_;
};

#endif
