#ifndef HRM_DATA_H_
#define HRM_DATA_H_

#include "../../kpworkout.h"
#include <glib.h>

typedef enum {
  HRM_EXE_NONE,
  HRM_EXE_BASIC_USE,
  HRM_EXE_SET_1,
  HRM_EXE_SET_2,
  HRM_EXE_SET_3,
  HRM_EXE_SET_4,
  HRM_EXE_SET_5,
  HRM_EXE_SET_NOT_SUPPORTED,
} KPHrmExercise;

typedef struct HrmLimitData_ {
  gshort          number; /* There can be many different limits in the HRM */
  
  gshort          min;
  gshort          max;

  /* Below */
  gshort          b_h;
  gshort          b_m;
  gshort          b_s;
  
  /* Inside */
  gshort          i_h;
  gshort          i_m;
  gshort          i_s;

  /* Above */
  gshort          a_h;
  gshort          a_m;
  gshort          a_s;
} HrmLimitData;

typedef struct HrmData_
{
  gchar          *file;
  KPWorkout      *wo;

  guint           d;
  guint           m;
  guint           y;

  guint           h;
  guint           min;
  guint           s;
  
  guint           best_lap_number;
  guint           n_laps;
  guint           n_measurements; 

  guint           duration_h;
  guint           duration_m;
  guint           duration_s;
  guint           duration_t;
 
  guint           sampling_period;
  guint           n_samples;
  guint          *hr_samples;

  guint           avg_hr;
  guint           max_hr;
  
  guint           n_limits_used;
  HrmLimitData    limit_data[3];

  gdouble         kcal_used;
} HrmData;


#endif
