/* -*- c++ -*-
 *
 * statspageovernet.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_statspageovernet_h__
#define __kmldonkey_statspageovernet_h__

#include <qframe.h>
#include <qvbox.h>
#include <qsplitter.h>

class QScrollView;
class KTextBrowser;
class KListView;

#include "statspage.h"
#include "donkeyprotocol.h"

class StatsPageOvernetCallback : public ConsoleCallbackInterface
{
public:
    void callback(const QString& cmd, const QString& res);
    StatsPageOvernet *page;
};

class StatsPageOvernet : public QScrollView
{
    Q_OBJECT
public:
    StatsPageOvernet(QWidget *parent);
    void parseOvmd4(const QString &res);
    void parseOvstat(const QString &res);
    void parseOvstore(const QString &res);

    QVBox *box;

public slots:
    void slotUpdate();

protected:
    void showEvent(QShowEvent* event);
    void hideEvent(QHideEvent *);

private:
    StatsPageOvernetCallback *callback;

    void addItem(QString text);
};

#endif
