/***************************************************************************
                        kmfmultiportwidget.cpp  -  description
                           -------------------
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfmultiportwidget.h"


#include <qstring.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#include <kpushbutton.h>

#include "../core/kmferror.h"

KMFMultiPortWidget::KMFMultiPortWidget( QWidget *parent, const char *name ) : KMyFirewallMultiPortWidget( parent, name ) {
	m_err = new KMFError();
	m_err->setErrType( "OK" );
	lb_ports->clear();
	connect( b_add, SIGNAL( clicked() ), this, SLOT( addPort() ) );
	connect( b_remove, SIGNAL( clicked() ), this, SLOT( removePort() ) );
	connect( c_use_multiport, SIGNAL( toggled( bool ) ), this, SIGNAL( sigMultiPortChanged( bool ) ) );
}
KMFMultiPortWidget::~KMFMultiPortWidget() {}

void KMFMultiPortWidget::addPort() {
	QString port = "";
	port.setNum( sb_port->value() );
	if ( port.isEmpty() )
		return ;
	if ( lb_ports->count() > 14 )
		return ;

	for ( uint i = 0; i < lb_ports->count(); i++ )
		if ( lb_ports->text( i ) == port )
			return ;

	lb_ports->insertItem( port );
}

void KMFMultiPortWidget::addPort( QString& port ) {
	lb_ports->insertItem( port );
}

void KMFMultiPortWidget::removePort() {
	int index = -1;
	index = lb_ports->currentItem();
	if ( index > -1 )
		lb_ports->removeItem( index );
}

void KMFMultiPortWidget::removePort( int index ) {
	lb_ports->removeItem( index );
}

KMFError* KMFMultiPortWidget::getPortString( QString* value ) {
	for ( uint i = 0; i < lb_ports->count(); i++ ) {
		if ( *value != "" )
			value->append( "," );
		value->append( lb_ports->text( i ) );
	}
	if ( value->isEmpty() )
		return m_err;

	value->stripWhiteSpace();
	return m_err;
}

void KMFMultiPortWidget::setType( const QString& type ) {
	setEnabled( true );
	c_use_multiport->setChecked( true );
	if ( type == "src" )
		rb_src->setChecked( true );
	if ( type == "dest" )
		rb_dest->setChecked( true );
	if ( type == "equ" )
		rb_equ->setChecked( true );

}

void KMFMultiPortWidget::loadPortString( QString& str ) {
	if ( str.isEmpty() )
		return ;
	lb_ports->clear();
	int pos = -1;
	pos = str.find( "," );
	while ( pos > -1 ) {
		QString port = str.left( pos );
		lb_ports->insertItem( port );
		str = str.right( str.length() - pos - 1 );
		pos = str.find( "," );
	}
	if ( !str.isEmpty() ) {
		lb_ports->insertItem( str );
	}
}

void KMFMultiPortWidget::reset() {
	c_use_multiport->setChecked( false );
	rb_src->setChecked( false );
	rb_dest->setChecked( false );
	rb_equ->setChecked( false );
	lb_ports->clear();
}


QString& KMFMultiPortWidget::type() const {
	QString ret = "src";
	if ( rb_src->isChecked() )
		ret = "src";
	else if ( rb_dest->isChecked() )
		ret = "dest";
	else if ( rb_equ->isChecked() )
		ret = "equ";
	QString *val = new QString( ret );
	return *val;
}
#include "kmfmultiportwidget.moc"
