/***************************************************************************
                         kmfconfigdialog.cpp  -  description
                            -------------------
   begin                : Sat Feb 22 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfconfigdialog.h"
#include "kmfconfigdialog.moc"

#include <qstring.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qregexp.h>
#include <qmessagebox.h>

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kguiitem.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kmessagebox.h>

#include "kmfchecklistoutput.h"

KMFConfigDialog::KMFConfigDialog( QWidget *parent, const char *name, bool modal ) : KDialogBase( IconList, i18n( "Configure" ), Help | User1 | Ok | Cancel,
        Ok, parent, name, modal, true, i18n( "Try Auto Configuration" ) ) {
	loadIcons();
	childproc = new KShellProcess( "/bin/sh" );
	connect( childproc, SIGNAL( processExited( KProcess* ) ), this, SLOT( slotProcessExited( KProcess* ) ) ) ;
	connect( childproc, SIGNAL( receivedStdout( KProcess*, char*, int ) ), this, SLOT( slotReceivedOutput( KProcess*, char*, int ) ) );
	connect( childproc, SIGNAL( receivedStderr( KProcess*, char*, int ) ), this, SLOT( slotReceivedError( KProcess*, char*, int ) ) );
	connect( this, SIGNAL( user1Clicked() ), this, SLOT( slotAutoConf() ) );

	showButton( KDialogBase::User1, true );
	setupGeneral();
	setupPaths();
	setupInterfaces();
	slotReadConfig();
	if ( checkFirstRun() )
		slotAutoConf();
	resize( 500, 350 );
}

KMFConfigDialog::~KMFConfigDialog() {}

bool KMFConfigDialog::checkFirstRun() {
	KConfig * _config = kapp->config();
	_config->setGroup( "PATHS" );
	QString str_init = _config->readPathEntry( "init_path" );
	if ( str_init.isNull() || str_init.isEmpty() )
		return true;
	else
		return false;
}

void KMFConfigDialog::setupPaths() {
	QFrame * page = addPage( i18n( "System Paths" ), QString::null, icon_paths );
	QGridLayout *lay = new QGridLayout( page, 6, 2, 2 );
	QLabel *text = new QLabel( i18n( "<qt><b>Please specify the needed paths here.</b></qt>" ), page );
	m_lab_ipt_path = new QLabel( i18n( "<qt>Path to the <b>iptables</b> binary:</qt>" ), page );
	m_lab_modprobe_path = new QLabel( i18n( "<qt>Path to the <b>modprobe</b> binary:</qt>" ), page );
	m_lab_init_path = new QLabel( i18n( "<qt>Path to <b>init</b> directory:</qt>" ), page );
	m_lab_runlevel_path = new QLabel( i18n( "<qt>Path to the default <b>runlevel</b> directory:</qt>" ), page );
	m_url_ipt_path = new KURLRequester( "/usr/sbin/iptables", page );
	m_url_modprobe_path = new KURLRequester( "/usr/sbin/modprobe", page );
	m_url_init_path = new KURLRequester( "/etc/init.d", page );
	m_url_runlevel_path = new KURLRequester( "/etc/rc5.d", page );
	lay->addMultiCellWidget( text, 0, 0, 0, 1 );
	lay->addWidget( m_lab_ipt_path, 1, 0 );
	lay->addWidget( m_url_ipt_path, 1, 1 );
	lay->addWidget( m_lab_modprobe_path, 2, 0 );
	lay->addWidget( m_url_modprobe_path, 2, 1 );
	lay->addWidget( m_lab_init_path, 3, 0 );
	lay->addWidget( m_url_init_path, 3, 1 );
	lay->addWidget( m_lab_runlevel_path, 4, 0 );
	lay->addWidget( m_url_runlevel_path, 4, 1 );
}

void KMFConfigDialog::setupGeneral() {
	QFrame * page = addPage( i18n( "General Setting" ), QString::null, icon_general );
	QLabel *text = new QLabel( page );
	QGridLayout *lay = new QGridLayout( page, 2, 1, 2 );
	m_cb_show_splash = new QCheckBox( i18n( "Show splash screen on startup" ), page );
	m_cb_show_splash->setChecked( true );
	m_cb_gentoo_mode = new QCheckBox( i18n( "Enable Gentoo mode" ), page );
	connect( m_cb_gentoo_mode, SIGNAL( toggled( bool ) ), this, SLOT( slotEnableGentooMode( bool ) ) );
	//  QLabel *text2 = new QLabel( i18n("<qt>Click here to enable all warning and information messages you have disabled</qt>"), page);
	m_b_enable_warnings = new KPushButton( i18n( "Reenable All Messages" ), page );
	m_b_enable_warnings->setFixedHeight( 30 );
	connect( m_b_enable_warnings, SIGNAL( clicked() ), this, SLOT( slotEnableWarnings() ) );

	lay->addWidget( m_cb_show_splash, 0, 0 );
	text->setText( i18n( "<qt><p>As the Gentoo Linux distribution uses a non-standard "
	                     "init system it is required to enable this checkbox if you are a Gentoo user.<br> "
	                     "By doing this all needed settings should be set automaticaly for you.</qt>" ) );
	lay->addWidget( text, 1, 0 );
	lay->addWidget( m_cb_gentoo_mode, 2, 0 );
	lay->addWidget( m_b_enable_warnings, 3, 0 );

}

void KMFConfigDialog::setupInterfaces() {
	QFrame * page = addPage( i18n( "Network Interfaces" ), QString::null, icon_interfaces );
	QLabel *text = new QLabel( page );
	text->setText( i18n( "<qt>List all network interfaces that are available on your computer here.</qt>" ) );
	QGridLayout *lay = new QGridLayout( page, 2, 2, 2 );

	m_b_add_interface = new KPushButton( page, "hj" );
	m_b_add_interface->setText( i18n( "Add Interface" ) );
	m_b_add_interface->setFixedHeight( 30 );
	m_b_del_interface = new KPushButton( page, "hj" );
	m_b_del_interface->setFixedHeight( 30 );
	m_b_del_interface->setText( i18n( "Remove Interface" ) );
	connect( m_b_add_interface, SIGNAL( clicked() ), this, SLOT( slotAddInterface() ) );
	connect( m_b_del_interface, SIGNAL( clicked() ), this, SLOT( slotDelInterface() ) );

	m_sb_interface_number = new KIntSpinBox( page );
	m_lb_interfaces = new KListBox( page );
	m_cb_interface_name = new KComboBox( page );
	m_cb_interface_name->insertItem( "eth" );
	m_cb_interface_name->insertItem( "ppp" );
	m_cb_interface_name->insertItem( "ippp" );
	m_cb_interface_name->insertItem( "ppoe" );
	m_cb_interface_name->insertItem( "tun" );
	m_cb_interface_name->insertItem( "tap" );
	m_cb_interface_name->insertItem( "gre" );
	m_cb_interface_name->insertItem( "wlan" );
	m_cb_interface_name->insertItem( "lo" );

	m_cb_interface_name->setEditable(true);
	lay->addMultiCellWidget( text, 0, 0, 0, 2 );
	lay->addMultiCellWidget( m_cb_interface_name, 1, 1, 0, 0 );
	lay->addMultiCellWidget( m_sb_interface_number, 1, 1, 1, 2 );
	lay->addMultiCellWidget( m_lb_interfaces, 2, 4, 1, 2 );
	lay->addMultiCellWidget( m_b_add_interface, 2, 2, 0, 0 );
	lay->addMultiCellWidget( m_b_del_interface, 3, 3, 0, 0 );
	QSpacerItem* spacer = new QSpacerItem( 0, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	lay->addItem( spacer, 4, 0 );
}

void KMFConfigDialog::slotEnableGentooMode( bool enable ) {
	kdDebug() << "void KMFConfigDialog::slotEnableGentooMode( bool enable )" << endl;
	if ( enable ) {
		m_url_runlevel_path->setURL( "/etc/runlevels/default/" );
		m_url_ipt_path->setURL( "/sbin/iptables" );
		m_url_modprobe_path->setURL( "/sbin/modprobe" );
		m_url_init_path->setURL( "/etc/init.d/" );
	} else {
		m_url_runlevel_path->setURL( "/etc/init.d/rc5.d/" );
		m_url_ipt_path->setURL( "/usr/sbin/iptables" );
		m_url_modprobe_path->setURL( "/usr/sbin/modprobe" );
		m_url_init_path->setURL( "/etc/init.d/" );
	}
}

bool KMFConfigDialog::isRunning() {
	return childproc->isRunning();
}

void KMFConfigDialog::slotProcessExited( KProcess* ) {
	kdDebug() << "void KMFConfigDialog::slotProcessExited(KProcess*)" << endl;

}

void KMFConfigDialog::slotReceivedError( KProcess *, char *buffer, int buflen ) {
	kdDebug() << "void KMFConfigDialog::slotReceivedError(KProcess *, char *buffer, int buflen)" << endl;
	kdDebug() << "received string: " << QString::fromLatin1( buffer, buflen ) << endl;
}

void KMFConfigDialog::slotReceivedOutput( KProcess *, char *buffer, int buflen ) {
	kdDebug() << "void KMFConfigDialog::slotReceivedOutput(KProcess *, char *buffer, int buflen) " << endl;
	kdDebug() << "Buffer: " << buffer << endl;
	QString tmp = QString::fromLatin1( buffer, buflen );
	tmp = tmp.replace( QRegExp( "\n" ), "|" );
	kdDebug() << "Orig: " << tmp << endl;
	tmp = tmp.left( tmp.length() - 1 );
	kdDebug() << "Cut last Orig: " << tmp << endl;
	m_lb_interfaces->clear();
	while ( tmp != "" && !tmp.isEmpty() ) {
		int pos;
		QString in;
		int l;
		pos = tmp.find( "|" );
		if ( pos == -1 ) {
			in = tmp.left( pos );
			m_progView->appendLine( i18n( "Found Interface: " ).arg( in ) );
			m_lb_interfaces->insertItem( in );
			m_progView->setStatus( true, "0" );
			tmp = "";
		} else {
			kdDebug() << "found | at " << pos << endl;
			in = tmp.left( pos );
			kdDebug() << "Orig: " << tmp << endl;
			m_progView->appendLine( i18n( "Found Interface: " ).arg( in ) );
			m_lb_interfaces->insertItem( in );
			m_progView->setStatus( true, "0" );
			l = tmp.length();
			tmp = tmp.right( l - ( pos + 1 ) );
			kdDebug() << "Rest: " << tmp << endl;
		}
	}
}

void KMFConfigDialog::slotAutoConf() {
	kdDebug() << "void KMFConfig::slotAutoConf() " << endl;
	// Output widget for the checks
	m_progView = new KMFCheckListOutput( this, "progView", true );
	m_progView->show();
	m_progView->clearList();
	m_progView->appendLine( "Checking for iptables..." );

	bool found_ipt = false;

	FILE *sbin1;
	FILE *sbin2;
	FILE *sbin3;
	FILE *sbin4;
	FILE *sbin5;
	FILE *sbin6;

	sbin1 = fopen( "/usr/bin/iptables", "r" );
	sbin2 = fopen( "/usr/local/bin/iptables", "r" );
	sbin3 = fopen( "/sbin/iptables", "r" );
	sbin4 = fopen( "/usr/sbin/iptables", "r" );
	sbin5 = fopen( "/usr/local/sbin/iptables", "r" );
	sbin6 = fopen( "/bin/iptables", "r" );

	if ( sbin1 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/usr/bin/iptables" );
		fclose( sbin1 );
	} else if ( sbin2 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/usr/local/bin/iptables" );
		fclose( sbin2 );

	} else if ( sbin3 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/sbin/iptables" );
		fclose( sbin3 );
	} else if ( sbin4 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/usr/sbin/iptables" );
		fclose( sbin4 );
	} else if ( sbin5 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/usr/local/sbin/iptables" );
		fclose( sbin5 );
	} else if ( sbin6 != NULL ) {
		found_ipt = true;
		m_url_ipt_path->setURL( "/bin/iptables" );
		fclose( sbin6 );
	}

	if ( found_ipt ) {
		m_progView->setStatus( true, "0" );
	} else {
		m_progView->setStatus( true, i18n( "iptables binary not found. Make sure you have installed it and set the path manually." ) );
	}

	m_progView->appendLine( "Checking for modprobe..." );

	bool found_modprobe = false;

	sbin1 = fopen( "/usr/bin/modprobe", "r" );
	sbin2 = fopen( "/usr/local/bin/modprobe", "r" );
	sbin3 = fopen( "/sbin/modprobe", "r" );
	sbin4 = fopen( "/usr/sbin/modprobe", "r" );
	sbin5 = fopen( "/usr/local/sbin/modprobe", "r" );
	sbin6 = fopen( "/bin/modprobe", "r" );

	if ( sbin1 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/usr/bin/modprobe" );
		fclose( sbin1 );
	} else if ( sbin2 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/usr/local/bin/modprobe" );
		fclose( sbin2 );

	} else if ( sbin3 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/sbin/modprobe" );
		fclose( sbin3 );
	} else if ( sbin4 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/usr/sbin/modprobe" );
		fclose( sbin4 );
	} else if ( sbin5 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/usr/local/sbin/modprobe" );
		fclose( sbin5 );
	} else if ( sbin6 != NULL ) {
		found_modprobe = true;
		m_url_modprobe_path->setURL( "/bin/modprobe" );
		fclose( sbin6 );
	}

	if ( found_modprobe ) {
		m_progView->setStatus( true, "0" );
	} else {
		m_progView->setStatus( true, i18n( "modprobe binary not found. Make sure you have installed it and set the path manually." ) );
	}

	m_progView->appendLine( "Is this Gentoo ?" );
	sbin1 = fopen( "/usr/bin/emerge", "r" );
	if ( sbin1 != NULL ) {
		m_cb_gentoo_mode->setChecked( true );
		m_progView->appendLine( "This is Gentoo :-)" );
		m_progView->setStatus( true, "" );
		slotEnableGentooMode( true );
		m_progView->appendLine( "Setting paths..." );
		m_progView->setStatus( true, "" );
		fclose( sbin1 );
	} else {
		m_cb_gentoo_mode->setChecked( false );
		m_progView->appendLine( "This no Gentoo." );
		m_progView->appendLine( "Searching for the init.d dir ..." );
		sbin1 = fopen( "/etc/init.d", "r" );
		sbin2 = fopen( "/sbin/init.d", "r" );
		if ( sbin1 != NULL ) {
			m_url_init_path->setURL( "/etc/init.d" );
			m_progView->appendLine( "Found init.d at: /etc/init.d" );
			m_progView->setStatus( true, "0" );
			fclose( sbin1 );
		} else if ( sbin2 != NULL ) {
			m_url_init_path->setURL( "/sbin/init.d" );
			m_progView->appendLine( "Found init.d at: /sbin/init.d" );
			m_progView->setStatus( true, "0" );
			fclose( sbin2 );
		} else {
			m_progView->appendLine( "Sorry cant find <b>init.d</b> dir :-(" );
			m_progView->setStatus( false, i18n( "init.d directory not found. Please set the path manually." ) );
		}

		bool found_rl_dir = false;
		m_progView->appendLine( "Searching for Default Runlevel." );

		sbin1 = fopen( "/etc/init.d/rc2.d", "r" );
		sbin2 = fopen( "/etc/init.d/rc3.d", "r" );
		sbin3 = fopen( "/etc/init.d/rc5.d", "r" );
		if ( sbin1 != NULL || sbin2 != NULL || sbin3 != NULL ) {
			fclose( sbin1 );
			fclose( sbin2 );
			fclose( sbin3 );
			m_progView->appendLine( "Found Runlevel Dirs at: /etc/init.d/rcX.d\nRunlevel 5 is guessed to be the default runlevel." );
			m_progView->setStatus( true, "0" );
			m_url_runlevel_path->setURL( "/etc/init.d/rc5.d" );
		}

		sbin1 = fopen( "/etc/rc2.d", "r" );
		sbin2 = fopen( "/etc/rc3.d", "r" );
		sbin3 = fopen( "/etc/rc5.d", "r" );

		if ( sbin1 != NULL || sbin2 != NULL || sbin3 != NULL ) {
			fclose( sbin1 );
			fclose( sbin2 );
			fclose( sbin3 );
			// check for debian to set the right default runlevel
			sbin4 = fopen( "/etc/debian_version", "r" );
			if ( sbin4 != NULL ) {
				fclose( sbin4 );
				m_progView->appendLine( "Found Runlevel Dirs at: /etc/rcX.d\nThis is Debian setting Default Runlevel 2." );
				m_progView->setStatus( true, "0" );
				m_url_runlevel_path->setURL( "/etc/rc2.d" );
				found_rl_dir = true;
			} else {
				m_progView->appendLine( "Found Runlevel Dirs at: /etc/rcX.d\nRunlevel 5 is guessed to be the default runlevel." );
				m_progView->setStatus( true, "0" );
				m_url_runlevel_path->setURL( "/etc/rc5.d" );
				found_rl_dir = true;
			}
		}

		sbin1 = fopen( "/sbin/rc2.d", "r" );
		sbin2 = fopen( "/sbin/rc3.d", "r" );
		sbin3 = fopen( "/sbin/rc5.d", "r" );

		if ( sbin1 != NULL || sbin2 != NULL || sbin3 != NULL ) {
			fclose( sbin1 );
			fclose( sbin2 );
			fclose( sbin3 );
			m_progView->appendLine( "Found Runlevel Dirs at: /sbin/rcX.d\nRunlevel 5 is guessed to be the default runlevel." );
			m_progView->setStatus( true, "0" );
			m_url_runlevel_path->setURL( "/sbin/rc5.d" );
			found_rl_dir = true;
		}


		if ( !found_rl_dir ) {
			m_progView->appendLine( i18n( "Default runlevel directory not found.\nPlease set the path to\nyour default runlevel manually." ) );
			m_progView->setStatus( false, "" );
			m_url_runlevel_path->setURL( "" );
		}
	}


	m_progView->appendLine( i18n( "Searching for interfaces..." ) );
	childproc->clearArguments();
	*childproc << "/sbin/ifconfig | grep 'Link' | cut -f1 -d' '";
	childproc->start( KProcess::NotifyOnExit, KProcess::AllOutput );
}

void KMFConfigDialog::slotAddInterface() {
	QString int_name = m_cb_interface_name->currentText();
	int int_num = m_sb_interface_number->value();
	QString str_num;
	str_num.setNum( int_num );
	QString interface = int_name;
	if ( int_name != "lo" )
		interface += str_num;
	for ( uint i = 0;i < m_lb_interfaces->count();i++ ) {
		QString interf = m_lb_interfaces->text( i );
		if ( interface == interf ) {
			KMessageBox::sorry( this, i18n( "You cannot have more then one interface with the same name." ),
			                    i18n( "Configuration" ) );
			return ;
		}
	}
	m_lb_interfaces->insertItem( interface );
}

void KMFConfigDialog::slotDelInterface() {
	int index = m_lb_interfaces->currentItem();
	if ( index > -1 ) {
		switch ( QMessageBox::warning( this, i18n( "Configuration" ),
		                               i18n( "Are you sure that you want to delete\n"
		                                     "this interface?\n" ),
		                               i18n( "&OK" ), i18n( "&Cancel" ),
		                               0, 2 ) ) {

		case 0:     // OK clicked
			m_lb_interfaces->removeItem( index );
			break;
		}

	} else {
		KMessageBox::sorry( this, i18n( "You have to select an interface first before you can delete it." ),
		                    i18n( "Configuration" ) );
		return ;

	}
}
void KMFConfigDialog::slotReadConfig() {
	m_lb_interfaces->clear();
	KConfig* _config = kapp->config();
	_config->setGroup( "STARTUP" );
	QString str_show_splash = _config->readEntry( "show_splash" );

	if ( str_show_splash == "true" ) {
		m_cb_show_splash->setChecked( true );
	} else {
		m_cb_show_splash->setChecked( false );
	}

	_config->setGroup( "PATHS" );
	QString str_init = _config->readPathEntry( "init_path" );
	kdDebug() << "Found init path " << str_init << endl;
	QString str_ipt = _config->readPathEntry( "ipt_path" );
	kdDebug() << "Found ipt path " << str_ipt << endl;
	QString str_modprobe = _config->readPathEntry( "modprobe_path" );
	kdDebug() << "Found modprobe path " << str_modprobe << endl;
	QString str_rc_default_path = _config->readPathEntry( "rc_default_path" );
	kdDebug() << "Found rc_default_path path " << str_rc_default_path << endl;
	QString str_gentoo_mode = _config->readEntry( "gentoo_mode" );
	kdDebug() << "Found gentoo_mode " << str_gentoo_mode << endl;


	if ( str_gentoo_mode == "true" ) {
		m_cb_gentoo_mode->setChecked( true );
	} else {
		m_cb_gentoo_mode->setChecked( false );
	}


	if ( !str_init.isEmpty() ) {
		m_url_init_path->setURL( str_init );
	} else {
		m_url_init_path->setURL( "/etc/init.d/" );
	}

	if ( !str_ipt.isEmpty() ) {
		m_url_ipt_path->setURL( str_ipt );
	} else {
		m_url_ipt_path->setURL( "/usr/sbin/iptables" );
	}

	if ( !str_modprobe.isEmpty() ) {
		m_url_modprobe_path->setURL( str_modprobe );
	} else {
		m_url_modprobe_path->setURL( "/sbin/modprobe" );
	}

	if ( !str_rc_default_path.isEmpty() ) {
		m_url_runlevel_path->setURL( str_rc_default_path );
	} else {
		if ( str_gentoo_mode == "true" ) {
			m_url_runlevel_path->setURL( "/etc/runlevels/default/" );
		} else {
			m_url_runlevel_path->setURL( "/etc/init.d/rc5.d/" );
		}
	}

	// interfaces
	_config->setGroup( "INTERFACES" );
	QStringList interf;
	interf = _config->readListEntry( "interface" );
	for ( uint i = 0; i < interf.count(); i++ ) {
		QString interface = *interf.at( i );
		kdDebug() << "Found Interface list " << interface << endl;
		m_lb_interfaces-> insertItem( interface );
	}
}
void KMFConfigDialog::accept() {
	kdDebug() << "void KMFConfigDialog::accept()" << endl;
	slotSaveConfig();
}

void KMFConfigDialog::slotSaveConfig() {
	KConfig * _config = kapp->config();
	// paths
	_config->setGroup( "STARTUP" );
	_config->writeEntry( "show_splash", m_cb_show_splash->isChecked() );

	_config->setGroup( "PATHS" );
	_config->writeEntry( "gentoo_mode", m_cb_gentoo_mode->isChecked() );

	if ( !m_url_ipt_path->url().isEmpty() ) {
		QString ipt_path = m_url_ipt_path->url();
		kdDebug() << "Found ipt-path " << ipt_path << endl;
		_config->setGroup( "PATHS" );
		_config->writePathEntry( "ipt_path", ipt_path );
	} else {
		KMessageBox::sorry( this, i18n( "Please specify the path to the iptables program." ),
		                    i18n( "Configuration" ) );
		return ;
	}

	if ( !m_url_modprobe_path->url().isEmpty() ) {
		QString modprobe_path = m_url_modprobe_path->url();
		kdDebug() << "Found ipt-path " << modprobe_path << endl;
		_config->setGroup( "PATHS" );
		_config->writePathEntry( "modprobe_path", modprobe_path );
	} else {
		KMessageBox::sorry( this, i18n( "Please specify the path to the modprobe program." ), i18n( "Configuration" ) );
		return ;
	}

	if ( !m_url_init_path->url().isEmpty() ) {
		QString init_path = m_url_init_path->url();
		kdDebug() << "Found init-path " << init_path << endl;
		_config->setGroup( "PATHS" );
		_config->writePathEntry( "init_path", init_path );

	} else {
		KMessageBox::sorry( this, i18n( "Please specify the path to your System V - Init Scripts." ), i18n( "Configuration" ) );
		return ;
	}

	if ( !m_url_runlevel_path->url().isEmpty() ) {
		QString rc_default_path = m_url_runlevel_path->url();
		kdDebug() << "Found rc_default_path " << rc_default_path << endl;
		_config->setGroup( "PATHS" );
		_config->writePathEntry( "rc_default_path", rc_default_path );

	} else {
		KMessageBox::sorry( this, i18n( "Please specify the path to your default Runlevel directory." ), i18n( "Configuration" ) );
		return ;
	}

	// interfaces
	QStringList ints;
	for ( uint i = 0;i < m_lb_interfaces->count();i++ ) {
		QString interf = m_lb_interfaces->text( i );
		if ( !interf.isEmpty() ) {
			kdDebug() << "Found Interface " << interf << endl;
			ints << interf;
		}
	}
	_config->setGroup( "INTERFACES" );
	_config->writeEntry( "interface", ints );
	_config->sync();
	QDialog::accept();
}

void KMFConfigDialog::slotEnableWarnings() {
	kdDebug() << "KMFConfigDialog::slotEnableWarnings()" << endl;
	KMessageBox::enableAllMessages();
	KMessageBox::information( this, i18n( "Reenabled all warnings." ) );
}

void KMFConfigDialog::loadIcons() {
	KIconLoader * loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "about_kde";
	icon_general = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "folder";
	icon_paths = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "network";
	icon_interfaces = loader->loadIcon( icon_name, KIcon::Desktop );

}

