/***************************************************************************
                       kmyfirewall.cpp  -  description
                          -------------------
 begin                : Sun Jan 27 21:17:58 CET 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmyfirewall.h"

// QT includes
#include <qmessagebox.h>
#include <qtextstream.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qstringlist.h>

// KDE includes
#include <kapplication.h>
#include <kaction.h>
#include <kaccel.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kprocess.h>
#include <kdebug.h>
#include <dcopclient.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <kstdguiitem.h>
#include <kcmdlineargs.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <kfileitem.h>

// C includes
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

// project includes
#include "kmfapp.h"
#include "core/kmferror.h"
#include "core/kmferrorhandler.h"
#include "core/kmfdoc.h"
#include "kmfconfigdialog.h"
#include "kmfoutputviewer.h"
#include "kmfdisclaimer.h"
#include "kmfwizard.h"
#include "kmfruleedit.h"
#include "kmfchainedit.h"
#include "kmfdocoptions.h"
#include "kmfnewchaindlg.h"
#include "kmfnewdocdlg.h"



KMyFirewall::KMyFirewall( QWidget* parent, const char *name ) : KMainWindow( parent, name ) {
	m_new_chain = new KMFNewChainDlg();
	connect( m_new_chain, SIGNAL( documentChanged( KMFDoc* ) ), this, SLOT( slotLoadDocument( KMFDoc* ) ) );
	m_editdoc = new KMFDocOptions( this , "m_editdoc" );
	connect( m_editdoc, SIGNAL( sigDocumentChanged( KMFDoc* ) ), this, SLOT( slotLoadDocument( KMFDoc* ) ) );
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMyFirewall" );
	kdDebug() << "kmfdoc = new KMFDoc(this,kmfdoc);" << endl;
	kmfdoc = new KMFDoc( this, "kmfdoc" );
	setCaption( i18n( "No File Loaded" ) );
	has_open_doc = false;

	set_splash_status( i18n("Init statusbar...") );
	initStatusBar();
	set_splash_status( i18n("Init menu...") );
	initMenu();
	set_splash_status( i18n("Init GUI...") );
	initView();
	set_splash_status( i18n("Init actions...") );
	initActions();
	set_splash_status( i18n("Read configuration...") );
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	QString ipt_path = "";
	QString init_path = "";
	QString install_path = "";
	ipt_path = _config->readPathEntry( "ipt_path" );
	init_path = _config->readPathEntry( "init_path" );
	install_path = _config->readPathEntry( "install_path" );
// 	showDisclaimer();
	bool configured = true;
	if ( ipt_path.isEmpty() || init_path.isEmpty() || install_path.isEmpty() ) {
		configured = false;
	}
	if ( checkRoot() ) {
		if ( configured ) {
			set_splash_status( i18n("Restoring session...") );
			slotRestoreSession();
		} else {
			closeSplash();
			slotConfigureKMF();
			slotFileNew();
		}
		setActiveWindow(); // Make sure this window gets keyboard focus
		raise(); // Make sure the window is now on top of other windows
		statusBar()->changeItem( "Ready", 500 );
		slotCheckStatus();
	} else {
		close(); // User indicated an abort is needed, so close the main window
	}
}

KMyFirewall::~KMyFirewall() {}

void KMyFirewall::initActions() {
	// Custom Actions
	actionExportShellScript = new KAction( i18n( "&Export Script..." ), "fileexport", 0 , this, SLOT( slotExportShellScript() ),
	                                       actionCollection(), "export_script" );

	actionOutputViewer = new KAction( i18n( "&Output Viewer" ), "openterm", 0 , this, SLOT( slotShowOutputViewer() ),
	                                  actionCollection(), "output_viewer" );

	actionPreviewScript = new KAction( i18n( "&Preview Script" ), "mime_txt", 0 , this, SLOT( slotShowScript() ),
	                                   actionCollection(), "preview_script" );

	actionShowConfig = new KAction( i18n( "Show &All Tables" ), "messagebox_info", 0 , this, SLOT( showIPTConfig() ),
	                                actionCollection(), "show_ipt_config" );

	actionShowFilter = new KAction( i18n( "Show &Filter Table" ), "messagebox_info", 0 , this, SLOT( slotShowFilter() ),
	                                actionCollection(), "show_filter" );

	actionShowNat = new KAction( i18n( "Show &Nat Table" ), "messagebox_info", 0 , this, SLOT( slotShowNat() ),
	                             actionCollection(), "show_nat" );

	actionShowMangle = new KAction( i18n( "Show &Mangle Table" ), "messagebox_info", 0 , this, SLOT( slotShowMangle() ),
	                                actionCollection(), "show_mangle" );

	actionMenu = new KActionMenu( i18n( "Show IPTables Configuration" ), "messagebox_info", this , "show_menu" );

	actionMenu->insert( actionShowConfig );
	actionMenu->insert( actionShowFilter );
	actionMenu->insert( actionShowNat );
	actionMenu->insert( actionShowMangle );
	actionMenu->setDelayed( false );
	actionMenu->setStickyMenu( true );
	actionCollection() ->insert( actionMenu );

	actionStopFw = new KAction( i18n( "&Reset IPTables" ), "decrypted", 0 , this, SLOT( resetFirewall() ),
	                            actionCollection(), "reset_iptables" );

	actionRunFw = new KAction( i18n( "Run Fir&ewall" ), "encrypted", 0 , this, SLOT( runFirewall() ),
	                           actionCollection(), "run_firewall" );


	actionEditChain = new KAction( i18n( "&Edit Chain" ), "configure_toolbars", 0 , this, SLOT( slotEditChain() ),
	                               actionCollection(), "edit_chain" );

	actionNewChain = new KAction( i18n( "Add New Chain..." ), "view_tree", 0 , this, SLOT( slotNewChain() ),
	                              actionCollection(), "new_chain" );

	actionDelChain = new KAction( i18n( "Delete Chain" ), "editdelete", 0 , this, SLOT( slotDelChain() ),
	                              actionCollection(), "del_chain" );

	actionNewRule = new KAction( i18n( "Add New Rule..." ), "nfs_unmount", 0 , this, SLOT( slotNewRule() ),
	                             actionCollection(), "new_rule" );

	actionDelRule = new KAction( i18n( "Delete Rule" ), "editdelete", 0 , this, SLOT( slotDelRule() ),
	                             actionCollection(), "del_rule" );

	actionEditDocOptions = new KAction( i18n( "&Configure Firewall Options..." ), "configure", 0 , this, SLOT( slotEditDocOptions() ),
	                                    actionCollection(), "edit_doc_options" );

	actionInstallFW = new KAction( i18n( "&Install Firewall" ), "down", 0 , this, SLOT( slotInstallFirewall() ),
	                               actionCollection(), "install_firewall" );

	actionUninstallFW = new KAction( i18n( "&Uninstall Firewall" ), "up", 0 , this, SLOT( slotUninstallFirewall() ),
	                                 actionCollection(), "uninstall_firewall" );

	actionStartWizard = new KAction( i18n( "&Start Wizard" ), "wizard", 0 , this, SLOT( slotStartWizard() ),
	                                 actionCollection(), "start_wizard" );

	// KStdAction
	actionNew = KStdAction::openNew( this, SLOT( slotFileNew() ),
	                                 actionCollection(), "new" );

	actionClose = KStdAction::close( this, SLOT( slotFileClose() ),
	                                 actionCollection(), "close" );

	actionOpen = KStdAction::open( this, SLOT( slotFileOpen() ),
	                               actionCollection(), "open" );

	actionSave = KStdAction::save( this, SLOT( slotFileSave() ),
	                               actionCollection(), "save" );

	actionSaveAs = KStdAction::saveAs( this, SLOT( slotFileSaveAs() ),
	                                   actionCollection(), "save_as" );

	actionQuit = KStdAction::quit( this, SLOT( slotQuitApp() ),
	                               actionCollection(), "quit" );
  actionLoadTemplate = new KAction( i18n( "&Load Template..." ), "wizard", 0 , this, SLOT( slotLoadTemplate() ),
	                                 actionCollection(), "load_template" );
	KStdAction::showToolbar( this, SLOT( toggleToolBar() ) , actionCollection() );
	KStdAction::showStatusbar( this, SLOT( toggleStatusBar() ), actionCollection() );
	KStdAction::preferences( this, SLOT( slotConfigureKMF() ), actionCollection() );

	createGUI(   /*"/usr/src/kde-cvs/kdenonbeta/kmyfirewall/kmyfirewall/kmyfirewallui.rc"*/ );
}
//check for the uid etc...
bool KMyFirewall::checkRoot() {
	// Is application started as root?
	if ( getuid() != 0 ) {
		closeSplash();
		const QString & msg = i18n( "<qt><p><b>KMyFirewall was not started as user <i>root</i>.</b><br>"
		                            "If you continue you will not be able to test or install new firewalls.</p>"
		                            "<p><b>Do you still want to continue?</b></p></qt>" );
		int choise = KMessageBox::warningYesNo( NULL, msg, i18n( "Warning" ), KStdGuiItem::yes(), KStdGuiItem::no(), "not_root_warning" );
		switch ( choise ) {
			case 4:
				kdDebug() << "Clicked NO" << endl;
				return false; // Abort and prevent application continuing from here
			case 3:
				kdDebug() << "Clicked Yes" << endl;
				break;
			default:
				return false; // Any action but pressing 'yes' will abort application
		}
	}

	const QString& msg = i18n( "<b>Please note that this KMyFirewall version is a beta release</b>.<br>"
	                           "Therefore you are advised to test, before trusting, "
	                           "any of the firewalls you create using this release." );

  KConfig* _config = kapp->config();
	_config->setGroup( "Notification Messages" );
  QString warn = "";
	warn = _config->readEntry( "beta_version_warning" );
  if ( warn != "false" )
		closeSplash();
	KMessageBox::information( NULL, msg, i18n( "Beta Information" ), "beta_version_warning", 0 );
	return true;
}

void KMyFirewall::slotProcessExited( KProcess * ) {}

bool KMyFirewall::saveQuit() {
	if ( !kmfdoc->isSaved() && !kmfdoc->isEmpty() && has_open_doc ) {
		const QString & msg = i18n( "<p>Do you want to save the changes before you quit?" );
		const QString& title = i18n( "Quit" );
		int doit = KMessageBox::questionYesNoCancel ( this , msg, title );
		kdDebug() << "Message Box returned: " << doit << endl;
		if ( doit == 3 ) { // OK clicked
			slotFileSave();
			has_open_doc = false;
			return true;
		}
		if ( doit == 2 ) { // Cancel clicked
			return false;
		}
		if ( doit == 4 ) { // No clicked
			has_open_doc = false;
			return true;
		}
		return false;
	}
	return true;
}

void KMyFirewall::slotQuitApp() {
	bool quit = saveQuit();
	if ( quit ) {

		kapp->quit();
	}
}

KMFDoc* KMyFirewall::getDoc() {
	return kmfdoc;
}

void KMyFirewall::closeEvent( QCloseEvent* ) {
	slotQuitApp();
}

void KMyFirewall::toggleToolBar() {
	if ( toolBar() ->isVisible() )
		toolBar() ->hide();
	else
		toolBar() ->show();
}
void KMyFirewall::toggleStatusBar() {
	if ( statusBar() ->isVisible() )
		statusBar() ->hide();
	else
		statusBar() ->show();
}

void KMyFirewall::initStatusBar() {
	statusBar() ->insertItem( i18n( "Starting Up" ), 0, true );
	statusBar() ->insertItem( i18n( "" ), 1, true );
}

void KMyFirewall::initMenu() {
	KPopupMenu *help = helpMenu();
	menuBar() ->insertItem( i18n( "&Help" ), help );
}
void KMyFirewall::initView() {
	m_ruleedit = new KMFRuleEdit( this, "ruleeditor", 0 );
	connect( this, SIGNAL( sigHasDoc( bool ) ), m_ruleedit, SLOT( setEnabled( bool ) ) );
	m_ruleedit->loadDoc( kmfdoc );
	setCentralWidget( m_ruleedit );
  kdDebug() << "\n\nCalling m_ruleedit->show()\n" << endl;
}

/** This function copys the new doc to the member kfmdoc  */
void KMyFirewall::slotLoadDocument( KMFDoc* doc ) {
	kdDebug() << "KMyFirewall::slotLoadDocument(KMFDoc& doc)" << endl;
	if ( doc == 0 ) {
		kdDebug() << "KMyFirewall::slotLoadDocument(KMFDoc& doc)\n kmfdoc == 0" << endl;
		m_err->setErrType( "FATAL" );
		const QString msg = i18n( "<p>KMyFirewall::slotLoadDocument(KMFDoc& doc)"
		                          "<p>doc == 0<p>This is a bug." );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	kmfdoc = doc;
	connect( this, SIGNAL( documentChanged( KMFDoc* ) ), m_ruleedit, SLOT( slotLoadDocument( KMFDoc* ) ) );
	connect( kmfdoc, SIGNAL( documentChanged() ), this, SLOT( slotEnableSave() ) );
	emit documentChanged( kmfdoc );
	toggleActions( true );
	has_open_doc = true;
	actionSave->setEnabled( true );
	m_ruleedit->loadDoc( kmfdoc );
	slotCheckStatus();
	kdDebug() << "exit from: KMyFirewall::slotLoadDocument( KMFDoc* doc )" << endl;
}
void KMyFirewall::slotReloadDocument() {
	slotLoadDocument( kmfdoc );
}
void KMyFirewall::slotEnableSave() {
	actionSave->setEnabled( true );
}
void KMyFirewall::slotCreateFirewallScript() {
	kmfdoc -> createFirewallScript();
}

void KMyFirewall::slotFileOpen() {
	kdDebug() << "KMyFirewall::slotFileOpen()" << endl;
	KURL url = KFileDialog::getOpenURL( ":", "*.kmfrs|KMyFirewall Ruleset(*.kmfrs)" );
	QString xmlfile = url.path();
	if ( url.path().isEmpty() ) {
		return ;
	} else {
		slotFileClose();
		statusBar() ->message( i18n( "Open file: " ) + url.path() , 5000 );
		m_err = parseDocument( url );
		if ( m_err_handler->showError( m_err ) ) {
			return ;
		}
	}
}

void KMyFirewall::slotLoadTemplate() {
  KStandardDirs std_dir;
  QString dir = std_dir.findResourceDir("data","kmyfirewall/templates/");
  dir = dir.append("/kmyfirewall/templates/");
  kdDebug() << "Found Data dir at: " << dir << endl;
	KURL url = KFileDialog::getOpenURL( dir, "*.kmfrs|KMyFirewall Ruleset (*.kmfrs)" );
	QString xmlfile = url.path();
	if ( url.path().isEmpty() ) {
		return ;
	} else {
		slotFileClose();
		statusBar() ->message( i18n( "Open file: " ) + url.path() , 5000 );
		m_err = parseDocument( url );
		m_err_handler->showError( m_err );
	}
  kmfdoc->setFileName( i18n("Untitled") );
	setCaption(i18n("Untitled"));
	kmfdoc->changed();
}

void KMyFirewall::slotFileClose() {
	bool choose_save = false;
	if ( !kmfdoc->isSaved() && !kmfdoc->isEmpty() && has_open_doc ) {
		switch ( QMessageBox::warning( this, i18n( "Save Changed Data?" ),
		                               i18n( "This firewall configuration has been changed since it was last saved.\n\n"
		                                     "What do you want to do with these changes?\n" ),
		                               i18n( "&Cancel" ), i18n( "&Discard" ), i18n( "&Save" ),
		                               2, 3 ) ) {

			case 0:
				kdDebug() << "Clicked Cancel" << endl;
				return ;
			case 1:
				kdDebug() << "Clicked Discard" << endl;
				break;
			case 2:
				kdDebug() << "Clicked Save" << endl;
				choose_save = true;
				slotFileSave();
				break;
		}
	}
	if ( !choose_save ) {
		kmfdoc->clear();
		slotLoadDocument( kmfdoc );
		KConfig* _config = kapp->config();
		_config->setGroup( "CURRENTCONFIG" );
		_config->writePathEntry( "current_configuration", QString::null );
		actionSave->setEnabled( false );
		setCaption( i18n("No File Loaded") );
		has_open_doc = false;
		toggleActions( false );
	}
}

KMFError* KMyFirewall::parseDocument( const KURL& url ) {
	kdDebug() << "void KMyFirewall::parseDocument(QString& file)" << endl;
  KIO::UDSEntry f_props;

  if (! KIO::NetAccess::stat( url , f_props ) ) {
    const QString msg =  i18n("<qt><p>The file <b>%1</b> could not be loaded.</p>"
															"<p>If you are working with files stored on remote computers "
															"make shure that the network is up and the fileserver runing.</qt>").arg(url.url());
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		return m_err;
	}
  KFileItem *props = new KFileItem(f_props,url);
  kdDebug() << "Found file permissions: " << props->permissionsString() << endl;
  if ( !props->isReadable() ) {
    const QString msg =  i18n("<qt><p>You don't have the permissions to read file: <b>%1</b></p></qt>").arg(url.url());
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		return m_err;
	}

	kmfdoc = kmfdoc->parseXMLRuleset( url );

	if ( kmfdoc == 0 ) {
		kdDebug() << "void KMyFirewall::parseDocument(QString& file)\nkmfdoc == 0" << endl;
		KConfig* _config = kapp->config();
		_config->setGroup( "CURRENTCONFIG" );
		_config->writePathEntry( "current_configuration", QString::null );
		kmfdoc->clear();
		m_err->setErrType( "NORMAL" );
		const QString msg = i18n( "<p>Unable to load file %1" ).arg( url.url() );
		m_err->setErrMsg( msg );
		return m_err;
	}
  if ( kmfdoc->url().fileName() == i18n("Untitled") ) {
		m_err->setErrType( "NORMAL" );
	  m_err->setErrMsg(i18n("<qt><p><b>Loading <i>%1</i> Failed!</b></p>"
													"<p>Please make shure that you have the permissions to read to this file.<br>"
													"If you are working with remotley stored files "
													"make shure that the target host and the directory is reachable. "
													"</p></qt>").arg( url.url() ) );
		closeSplash();
		return m_err;
	}

	const QString filename = url.fileName();
	slotLoadDocument( kmfdoc );
	setCaption( filename );
	kmfdoc->saved();

  if ( url.fileName() != "workstation_template.kmfrs"
			&& url.fileName() != "nat_router_template.kmfrs"
			&& url.fileName() != "router_template.kmfrs") {
		KConfig* _config = kapp->config();
		_config->setGroup( "CURRENTCONFIG" );
		_config->writePathEntry( "current_configuration", url.path() );
		_config->sync();
		kdDebug() << "\nWrote URL: " <<  url.path() << "\n" << endl;
  } else {
		kmfdoc->setFileName(i18n("Untitled"));
    setCaption(i18n("Untitled"));
		KConfig* _config = kapp->config();
		_config->setGroup( "CURRENTCONFIG" );
		_config->writePathEntry( "current_configuration", QString::null );
  }
	m_err->setErrType( "OK" );
	const QString msg = "";
	m_err->setErrMsg( msg );
	return m_err;
}

KMFError* KMyFirewall::saveDocument( const KURL& url ) {
	kdDebug() << "void KMyFirewall::saveDocument( const KURL& url )" << endl;
	kdDebug() << "Writing File: " << url.fileName() << endl;


	m_err = kmfdoc->exportXMLRuleset( url );
  if ( m_err->errNum() != 0 )
		return m_err;
	kmfdoc->setUrl(url);
	KConfig* _config = kapp->config();
	_config->setGroup( "CURRENTCONFIG" );
	QString str_url = url.path();
	_config->writePathEntry( "current_configuration", str_url );
	 kdDebug() << "\nWrote URL: " << str_url << "\n" << endl;
	QString filename = kmfdoc->url().fileName();
	setCaption( filename );
	return m_err;
}

void KMyFirewall::slotRestoreSession() {
	KCmdLineArgs * args = KCmdLineArgs::parsedArgs();
	KConfig* _config = kapp->config();
	_config->setGroup( "CURRENTCONFIG" );

	QString curr = "";
	if ( args->count() == 1 ) {
		curr = args->arg( 0 );
	} else {
		curr = _config->readPathEntry( "current_configuration" );
	}

	args->clear();
  KURL url(curr);
	if ( url.fileName().isEmpty() ) {
		toggleActions( false );
	} else {
		const QString file = curr;
		m_err = parseDocument( url );
		if ( m_err_handler->showError( m_err ) ) {
			slotCheckStatus();
		} else {
			slotCheckStatus();
			_config->writePathEntry( "current_configuration", QString::null );
			toggleActions( false );
			actionSave->setEnabled( false );
			has_open_doc = false;
			toggleActions( false );
		}
	}
}


void KMyFirewall::slotFileNew() {
	kdDebug() <<  "KMyFirewall::slotFileNew()" << endl;
	if ( hasOpenDoc() )
		slotFileClose();

  KMFNewDocDlg *dlg = new KMFNewDocDlg(0,"dlg",QWidget::WDestructiveClose | QWidget::WStyle_Customize | QWidget::WStyle_NoBorder /*| QWidget::WX11BypassWM | QWidget::WStyle_StaysOnTop*/);
  dlg->show();
  connect( dlg, SIGNAL( sigNewDocLoadWizard() ), this, SLOT( slotStartWizard() ) );
  connect( dlg, SIGNAL( sigNewDocLoadTemplate() ), this, SLOT( slotLoadTemplate() ) );
  connect( dlg, SIGNAL( sigNewDocLoadEmpty() ), this, SLOT( slotLoadEmptyRuleset() ) );
  connect( dlg, SIGNAL( sigNewDocLoadSaved() ), this, SLOT( slotFileOpen() ) );
}

void KMyFirewall::slotLoadEmptyRuleset() {
		kdDebug() << "slotLoadEmptyRuleset()" << endl;
		kmfdoc->clear();
		setCaption(i18n("Untitled"));
		slotLoadDocument( kmfdoc );
		toggleActions( true );
		slotEditDocOptions();
}

void KMyFirewall::slotFileSave() {
	if ( kmfdoc->isSaved() ) {
		statusBar() ->message( i18n( "No changes to save." ) , 5000 );
		actionSave->setEnabled( false );
		return ;
	}
	const KURL& url = kmfdoc->url();
	if ( url.fileName() != i18n("Untitled") ) {
		m_err = saveDocument( url );
		if ( m_err_handler->showError( m_err ) ) {
			kdDebug() << "Wrote file: " << url.path() << endl;
			kmfdoc->saved();
			actionSave->setEnabled( false );
			statusBar() ->message( i18n( "Wrote file: " ) + url.fileName(), 5000 );
		} else {
			statusBar() ->message( i18n( "Sorry couldn't write file: " ) + url.fileName(), 5000 );
			kdDebug() << "Sorry couldn't write File: " << url.fileName() << endl;
		}
	} else {
		slotFileSaveAs();
	}
}

void KMyFirewall::slotFileSaveAs() {
	kdDebug() << "KMyFirewallMainView::slotCreateXMLRuleset()" << endl;
	QString xmlfile;

	KURL url = KFileDialog::getSaveURL( ":", "*.kmfrs|KMyFirewall Ruleset (*.kmfrs)" );
	QString filename = url.fileName();
  if (url.fileName() == "")
		return;
  int answer = 0;
  while ( answer != 3 ) {
		if ( KIO::NetAccess::exists( url ) ) {
      if ( answer == 4 ) {
				slotFileSaveAs();
				return;
			} else {
				answer = KMessageBox::questionYesNo(this,i18n("<qt>File <b>%1</b> already exists!</p>"
																											"<p><b>Overwrite the existing file?</b></p></qt>").arg(url.url()));
			}
		} else {
			answer = 3;
		}
	} 
	QString extension = filename.right( 6 );
	if ( extension != ".kmfrs" ) {
		filename.append( ".kmfrs" );
    url.setFileName( filename );
	}
	m_err = saveDocument( url );
	if ( m_err_handler->showError( m_err ) ) {
		kmfdoc->saved();
		actionSave->setEnabled( false );
		statusBar() ->message( i18n( "Wrote File: " ) + url.fileName() , 5000 );
	} else {
		statusBar() ->message( i18n( "Sorry couldn't write file: " ) + url.fileName() , 5000 );
		kdDebug() << "Sorry couldn't write File: " << url.path() << endl;
	}
	kdDebug() << "Finished Saving" << endl;
}

void KMyFirewall::slotExportShellScript() {
	kdDebug() << "void KMyFirewall::slotExportShellScript()" << endl;
	KURL url = KFileDialog::getSaveURL( ":", "*.sh|Shell Script (*.sh)" );
  QString filename = url.fileName();
  if (url.fileName() == "")
		return;
	int answer = 0;
	while ( answer != 3 ) {
		if ( KIO::NetAccess::exists( url ) ) {
			if ( answer == 4 ) {
				slotExportShellScript();
				return;
			} else {
				answer = KMessageBox::warningYesNo(this,i18n("<qt>File <b>%1</b> already exists!</p>"
																											"<p><b>Overwrite the existing file?</b></p></qt>").arg(url.url()));
			}
		} else {
			answer = 3;
		}
	}
	QString extension = filename.right( 3 );
	if ( extension != ".sh" )
		filename.append( ".sh" );
	kdDebug() << "Found File name extension: " << extension << endl;
	url.setFileName(filename);
	KTempFile tempfile;
	m_err = kmfdoc->createFirewallScript( tempfile.name() );
	if ( m_err_handler->showError( m_err ) ) {
		if ( KIO::NetAccess::upload(tempfile.name(),url) ) {
			statusBar() ->message( i18n( "Wrote file: " ) + url.fileName() , 5000 );
		} else {
			kdDebug() << "Couldn't upload file!!!" << tempfile.name() << endl;
			KMessageBox::detailedError(this,i18n("<qt><p>Saving file: <b>%1</b> Failed!</p></qt>").arg( url.url() ),
                                  i18n("<qt><p>If you are working with remotely stored files "
																	"make shure that the target host and the directory is reachable. "
																	"</p></qt>")  );
		}
	}
	tempfile.unlink();
}

void KMyFirewall::slotConfigureKMF() {
	KMFConfigDialog *configDlg = new KMFConfigDialog( this, "config" );
	configDlg->exec();
}

void KMyFirewall::runFirewall() {
	m_ruleedit->slotRunFirewall();
}

void KMyFirewall::resetFirewall() {
	m_ruleedit->slotResetFirewall();
}
void KMyFirewall::slotShowOutputViewer() {
	m_ruleedit->slotShowOutputViewer();
}
void KMyFirewall::showIPTConfig() {
	m_ruleedit->slotShowIPTConfig();
}
void KMyFirewall::slotShowScript() {
	m_ruleedit->slotShowScript();
}
void KMyFirewall::slotShowFilter() {
	m_ruleedit->slotShowFilter();
}
void KMyFirewall::slotShowNat() {
	m_ruleedit->slotShowNat();
}
void KMyFirewall::slotShowMangle() {
	m_ruleedit->slotShowMangle();
}
void KMyFirewall::slotInstallFirewall() {
	m_ruleedit->slotInstallFirewall();
}

void KMyFirewall::slotUninstallFirewall() {
	m_ruleedit->slotUninstallFirewall();
}

void KMyFirewall::slotStartWizard() {
  slotFileClose();
  setCaption(i18n("Untitled"));
  kmfdoc->clear();
	KMFWizard * wiz = new KMFWizard( this );
	wiz->slotInitDocument();
	wiz->show();
}

void KMyFirewall::slotEditChain() {
	m_ruleedit->slotEditChain();
}

void KMyFirewall::slotDelChain() {
	m_ruleedit->slotDelChain();
}

void KMyFirewall::slotNewChain() {
	kdDebug() << "void KMyFirewall::slotNewChain()" << endl;
	m_new_chain->loadDoc( kmfdoc );
	m_new_chain->exec();
}
void KMyFirewall::slotNewRule() {
	m_ruleedit->slotAddRule();
}
void KMyFirewall::slotDelRule() {
	m_ruleedit->slotDelRule();
}
void KMyFirewall::slotEditDocOptions() {
	m_editdoc->loadDoc( kmfdoc );
	m_editdoc ->show();
}

void KMyFirewall::slotCheckStatus() {
	kdDebug() << "slotCheckStatus()" << endl;
	KConfig* _config = kapp->config();
	_config->setGroup( "FIREWALL_STATUS" );
	QString run = _config->readEntry( "running" );
	kdDebug() << "running = " << run << endl;

	if ( run == "on" ) {
		statusBar() ->changeItem( "Firewall is running", 0 );
	} else {
		statusBar() ->changeItem( "Firewall is not running", 0 );
	}

	FILE *sbin1;

	sbin1 = fopen( "/etc/kmyfirewall", "r" );

	if ( sbin1 != NULL ) {
		statusBar() ->changeItem( "Firewall is installed", 1 );
		fclose( sbin1 );
	} else {
		statusBar() ->changeItem( "Firewall is not installed", 1 );
	}
}
/** toggle the available actions  */
void KMyFirewall::toggleActions( bool on ) {
	if ( on ) {
		actionClose->setEnabled( true );
		actionSaveAs->setEnabled( true );
		actionRunFw->setEnabled( true );
		actionStopFw->setEnabled( true );
		actionPreviewScript->setEnabled( true );
		actionInstallFW->setEnabled( true );
		actionUninstallFW->setEnabled( true );
		actionShowConfig->setEnabled( true );
		actionShowFilter->setEnabled( true );
		actionShowNat->setEnabled( true );
		actionShowMangle->setEnabled( true );
		actionNewChain->setEnabled( true );
		actionDelChain->setEnabled( true );
		actionEditChain->setEnabled( true );
		actionNewRule->setEnabled( true );
		actionDelRule->setEnabled( true );
		actionEditDocOptions->setEnabled( true );
		actionOutputViewer->setEnabled( true );
		actionExportShellScript->setEnabled( true );
		actionMenu->setEnabled( true );
		// diable new and open file
		actionNew->setEnabled( false );
		actionOpen->setEnabled( false );
		emit sigHasDoc( true );
	} else {
		actionClose->setEnabled( false );
		actionSave->setEnabled( false );
		actionSaveAs->setEnabled( false );
		actionRunFw->setEnabled( false );
		actionStopFw->setEnabled( false );
		actionShowFilter->setEnabled( false );
		actionShowNat->setEnabled( false );
		actionShowMangle->setEnabled( false );
		actionPreviewScript->setEnabled( false );
		actionInstallFW->setEnabled( false );
		actionUninstallFW->setEnabled( false );
		actionOutputViewer->setEnabled( false );
		actionShowConfig->setEnabled( false );
		actionNewChain->setEnabled( false );
		actionDelChain->setEnabled( false );
		actionEditChain->setEnabled( false );
		actionNewRule->setEnabled( false );
		actionDelRule->setEnabled( false );
		actionEditDocOptions->setEnabled( false );
		actionStartWizard->setEnabled( false );
		actionExportShellScript->setEnabled( false );
		actionMenu->setEnabled( false );
		// enable new and open file
		actionNew->setEnabled( true );
		actionOpen->setEnabled( true );
		emit sigHasDoc( false );
	}
}

/** just show the Disclaimer */
void KMyFirewall::showDisclaimer() {
	KConfig * _config = kapp->config();
	_config->setGroup( "STARTUP" );
	QString disclaimer = _config->readEntry( "show_disclaimer" );
	kdDebug() << "Read show_disvlaimer: " << disclaimer << endl;
	if ( disclaimer == "true" ) {
    closeSplash();
		KMFDisclaimer * discl	= new KMFDisclaimer( this, "Disclaimer", true, true );
		int status = discl->exec();
		kdDebug() << "Disclaimer returned: " << status << endl;
		if ( status == 0 ) {
			kdDebug() << "Terminate Now" << endl;
			exit( 0 );
		}
	}
}

bool KMyFirewall::hasOpenDoc() {
	return has_open_doc;
}

#include "kmyfirewall.moc"
