#ifndef KSIPPREFERENCES_H_INCLUDED
#define KSIPPREFERENCES_H_INCLUDED

#include <qtabdialog.h>

#include "../dissipate2/sipclient.h"
#include "callaudio.h"

class QLineEdit;
class QMultiLineEdit;
class QButtonGroup;
class KSipPreferences : public QTabDialog
{
	Q_OBJECT
public:
	KSipPreferences( SipClient *client, CallAudio *ca, QWidget *parent = 0, const char *name = 0 );
	~KSipPreferences( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );
	void resetSettings( void );

private:
	enum ExpProxy { DontUseExpProxy, UseExpProxy };
	enum HideVia { NoHide, HideHop, HideRoute };
	enum CallForward { FwActive, FwInactive };
	enum Socket { UDP, TCP };
	enum Stun { stunYes, stunNo };
	enum Symmetric { symmetricYes, symmetricNo };
	enum SymMedia { symMediaYes, symMediaNo };
	
	SipClient *c;
	CallAudio *audio;
	QLineEdit *proxyaddr;
	QLineEdit *forwardaddr;
	QLineEdit *maxforwards;
	QLineEdit *phonebook;
	QLineEdit *expires;
	QLineEdit *subscribeExpires;
	QLineEdit *stunServerAddr;
	QLineEdit *stunRequestPeriod;
	QMultiLineEdit *forwardmsg;
	QMultiLineEdit *busymsg;
	QButtonGroup *expbg;
	QButtonGroup *hidebg;
	QButtonGroup *forbg;
	QButtonGroup *stun;
	QButtonGroup *symmetric;
	QButtonGroup *symMedia;
	QButtonGroup *socket;
	QLineEdit *mediaMinPort;
	QLineEdit *mediaMaxPort;
};

#endif // KSIPPREFERENCES_H_INCLUDED
