/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qlistbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kapplication.h>
#include <klocale.h>
#include "kxstitch.h"
#include "addcolordialog.h"
#include "newcolordialog.h"
#include "schememanager.h"
#include "flossscheme.h"
#include "flosslistboxitem.h"

AddColorDialog::AddColorDialog(QWidget *parent, QString schemeName)
  : AddColorDlg(parent,"AddColorDialog",true),
    m_schemeName(schemeName)
{
  setCaption(i18n("Add Colors"));
  SchemeName->setText(QString(i18n("Add colors from %1 scheme")).arg(schemeName));
  connect(NewColorButton,SIGNAL(clicked()),this,SLOT(slotNewColor()));
  connect(HelpButton,SIGNAL(clicked()),this,SLOT(slotContextHelp()));
}

AddColorDialog::~AddColorDialog()
{
  // nothing to be done
}

void AddColorDialog::slotContextHelp()
{
  kapp->invokeHelp("AddColorDialog");
}

void AddColorDialog::slotNewColor()
{
  Floss* floss = NewColorDialog::getFloss(m_schemeName);
  if (floss)
  {
    m_addedColors.append(floss);
    new FlossListBoxItem(ColorList, floss);
  }
}

void AddColorDialog::accept()
{
  FlossScheme* scheme = ((KXStitchApplication*)kapp)->scheme(m_schemeName);
  if (!m_addedColors.isEmpty())
  {
    for (Floss* f = m_addedColors.first() ; f ; f = m_addedColors.next())
      scheme->addFloss(f);
    ((KXStitchApplication*)kapp)->writeScheme(m_schemeName);
  }
  QDialog::accept();
}

void AddColorDialog::reject()
{
  m_addedColors.setAutoDelete(true);
  QDialog::reject();
}
