//LabPlot : AxesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qfontdialog.h>
#include <qstringlist.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "AxesDialog.h"

using namespace std;

//! Dialog for manipulating the Axis of an 2D or 3D Plot
AxesDialog::AxesDialog(Worksheet *p, const char *name, int axesnr)
	: Dialog(p, name)
{
	plot = p->getPlot(p->API());
	type = plot->Type();

	if (type == P2D || type == PSURFACE) {
		for (int i=0;i<4;i++)
			axis[i] = plot->getAxis(i);
	}
	else if (type == P3D || type == PQWT3D) {
		for (int i=0;i<12;i++)
			axis[i] = plot->getAxis(i);
	}
	else if (type == PPOLAR) {
		axis[0] = plot->getAxis(0);	// phi
		axis[1] = plot->getAxis(1);	// r
	}
	else if (type == PTERNARY)
		axis[0] = plot->getAxis(0);

	setCaption(i18n("Axes Settings"));
	
	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Axes"),hb);
	cb = new QCheckBox(i18n("Axis enabled "),hb);
	cb->setChecked(axis[axesnr]->enabled());
	QObject::connect(cb,SIGNAL(toggled(bool)),this,SLOT(axisEnabled(bool)));

	axeslb = new KListBox(vbox);
	QStringList list;
	double rmin=0, rmax=0;	// axes range
	if (type == P2D || type == PSURFACE) {
		list<<QString("x")<<QString("y")<<QString("y2")<<QString("x2");
		if(axesnr == 0 || axesnr == 3) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
	}
	else if (type == P3D || type == PQWT3D){
		list<<QString("x")<<QString("y")<<QString("z")<<QString("x2")<<QString("y2")<<QString("z2");
		list<<QString("x3")<<QString("y3")<<QString("z3")<<QString("x4")<<QString("y4")<<QString("z4");
		if(axesnr == 0 || axesnr == 3 || axesnr == 6 || axesnr == 9) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else if(axesnr == 1 || axesnr == 4 || axesnr == 7 || axesnr == 10) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
		else {
			rmin = plot->ActRanges()[2].rMin();
			rmax = plot->ActRanges()[2].rMax();
		}
	}
	else if (type == PPOLAR) {
		list<<QString("phi")<<QString("r");
		
		rmin = plot->ActRanges()[axesnr].rMin();
		rmax = plot->ActRanges()[axesnr].rMax();
	}
	else if (type == PTERNARY) {
		list<<QString("a");
		
		rmin = plot->ActRanges()[axesnr].rMin();
		rmax = plot->ActRanges()[axesnr].rMax();
	}
	
	axeslb->insertStringList(list);
	axeslb->setCurrentItem(axesnr);
	QObject::connect(axeslb,SIGNAL(selectionChanged()),this,SLOT(updateAxis()));

	QTabWidget *tw = new QTabWidget(vbox);

	QVBox *tab1 = new QVBox(tw);

	hb = new QHBox(tab1);
	new QLabel(i18n("Axis Scale :"),hb);
	ascb = new KComboBox(hb);
        QStringList slist;
        slist << i18n("linear");
        slist << i18n("log 10");
        slist << i18n("log 2");
        slist << i18n("log e");
        slist << i18n("sqrt");
        ascb->insertStringList(slist);
	ascb->setCurrentItem(axis[axesnr]->Scale());
	QObject::connect(ascb,SIGNAL(activated (int)),SLOT(updateScale(int)));

	hb = new QHBox(tab1);
	new QLabel(i18n("Scaling :"),hb);
	scaling = new KLineEdit(QString::number(axis[axesnr]->Scaling()),hb);
	new QLabel(i18n("Shift :"),hb);
	shift = new KLineEdit(QString::number(axis[axesnr]->Shift()),hb);

	new QLabel(i18n("Axis Range :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(i18n("From : "),hb);
	min = new KLineEdit(QString::number(rmin,'g',15),hb);
	new QLabel(i18n("To : "),hb);
	max = new KLineEdit(QString::number(rmax,'g',15),hb);
	
	if (type == PPOLAR) {
		min->setEnabled(FALSE);
		max->setEnabled(FALSE);
	}

	Label *l = axis[axesnr]->label();
	rtw = new RichTextWidget((QWidget *)tab1,l,0);

	// "Tics"
	QVBox *tab2 = new QVBox(tw);

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Position :"),hb);
	ticsposcb = new KComboBox(hb);
        QStringList plist;
        plist << i18n("out");
        plist << i18n("in");
        plist << i18n("in & out");
        plist << i18n("none");
        ticsposcb->insertStringList(plist);
        ticsposcb->setCurrentItem(axis[axesnr]->TicsPos());

	hb = new QHBox(tab2);
	cb2 = new QCheckBox(i18n("Major Tics enabled "),hb);
	cb2->setChecked(axis[axesnr]->MajorTicsEnabled());
	new QLabel(i18n("Nr. : "),hb);
	major = new KLineEdit(QString::number(axis[axesnr]->MajorTics()),hb);
	major->setValidator(new QIntValidator(major));

	hb = new QHBox(tab2);
	cb3 = new QCheckBox(i18n("Minor Tics enabled "),hb);
	cb3->setChecked(axis[axesnr]->MinorTicsEnabled());
	new QLabel(i18n("Nr. : "),hb);
	minor = new KLineEdit(QString::number(axis[axesnr]->MinorTics()),hb);
	minor->setValidator(new QIntValidator(minor));

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Font : "),hb);
	tf = axis[axesnr]->TicsFont();
	ticsfont = new KLineEdit(tf.family() + tr(" ") +
			QString::number(tf.pointSize()),hb);
	KPushButton *newticsfont = new KPushButton(i18n("New"),hb);
	QObject::connect(newticsfont,SIGNAL(clicked()),SLOT(selectTicsFont()));

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Format : "),hb);
	atlfcb = new KComboBox(hb);
	QStringList flist;
	flist << i18n("automatic") << i18n("normal") << i18n("scientific") << i18n("power of 10") << i18n("power of 2");
	flist << i18n("power of e") << i18n("sqrt") << i18n("time") << i18n("date") << i18n("datetime") << i18n("degree");
	atlfcb->insertStringList(flist);
	atlfcb->setCurrentItem(axis[axesnr]->TicsLabelFormat());
	QObject::connect(atlfcb,SIGNAL(activated(int)),this,SLOT(update_timeformat()));

	hb = new QHBox(tab2);
	new QLabel(i18n("date/time/datetime format (dd.MM.yyyy hh:mm:ss.zzz) : "),hb);
	timeformat = new KLineEdit(axis[axesnr]->DateTimeFormat(),hb);
	if (atlfcb->currentText() != i18n("time") && atlfcb->currentText() != i18n("date")
		&& atlfcb->currentText() != i18n("datetime"))
		timeformat->setDisabled("true");

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Precision : "),hb);
	tlple = new KLineEdit(QString::number(axis[axesnr]->TicsLabelPrecision()),hb);
	new QLabel(i18n("Tics Label Position : "),hb);
	tlgle = new KLineEdit(QString::number(axis[axesnr]->TicsLabelGap()),hb);

	hb = new QHBox(tab2);
	new QLabel(i18n("Prefix : "),hb);
	tlprefix = new KLineEdit(axis[axesnr]->TicsLabelPrefix(),hb);
	new QLabel(i18n("Suffix : "),hb);
	tlsuffix = new KLineEdit(axis[axesnr]->TicsLabelSuffix(),hb);

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Rotation : "),hb);
	tlrotation = new KLineEdit(QString::number(axis[axesnr]->TicsLabelRotation()),hb);
	tlrotation->setValidator(new QDoubleValidator(tlrotation));
	
	hb = new QHBox(tab2);
        new QLabel(i18n("Tics Color : "),hb);
        tc = axis[axesnr]->TicsColor();
        tcb = new KColorButton(tc,hb);
	QObject::connect(tcb,SIGNAL(changed(const QColor &)),SLOT(setTicsColor(const QColor &)));

	hb = new QHBox(tab2);
        new QLabel(i18n("Tics Label Color : "),hb);
        tlc = axis[axesnr]->TicsLabelColor();
        tlcb = new KColorButton(tlc,hb);
	QObject::connect(tlcb,SIGNAL(changed(const QColor &)),SLOT(setTicsLabelColor(const QColor &)));

	// grid & border
	QVBox *tab3 = new QVBox(tw);

	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Grid"),tab3);
	hb = new QHBox(gb);
	cb4 = new QCheckBox(i18n("Major Grid"),hb);
	cb4->setChecked(plot->gridEnabled(2*axesnr));
	cb5 = new QCheckBox(i18n("Minor Grid"),hb);
	cb5->setChecked(plot->gridEnabled(2*axesnr+1));
	hb = new QHBox(gb);
        new QLabel(i18n("Grid Color : "),hb);
        gc = axis[axesnr]->GridColor();
        gcb = new KColorButton(gc,hb);
	QObject::connect(gcb,SIGNAL(changed(const QColor &)),SLOT(setGridColor(const QColor &)));

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Border"),tab3);
	cb6 = new QCheckBox(i18n("Border enabled"),gb);
	hb = new QHBox(gb);
	cb6->setChecked(plot->borderEnabled(axesnr));
        new QLabel(i18n("Border Color : "),hb);
        bc = axis[axesnr]->BorderColor();
        bcb = new KColorButton(bc,hb);
	QObject::connect(bcb,SIGNAL(changed(const QColor &)),SLOT(setBorderColor(const QColor &)));

	tw->addTab(tab1,i18n("Main"));
	tw->addTab(tab2,i18n("Tics"));
	tw->addTab(tab3,i18n("Grid + Border"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize((int)(1.2*minimumSize().width()),minimumSize().height());
}

//! update values if scale changed
void AxesDialog::updateScale(int i) {
	if(i==LINEAR)
		minor->setText(QString("3"));
	else if (i==LOG10)
		minor->setText(QString("8"));
	else
		minor->setText(QString("0"));
}

//! enable timeformat lineedit if time selected
void AxesDialog::update_timeformat() {
	kdDebug()<<"ATLF text ="<<atlfcb->currentText()<<endl;
	if (atlfcb->currentText() == i18n("time") || atlfcb->currentText() == i18n("date")
		|| atlfcb->currentText() == i18n("datetime") )
		timeformat->setEnabled("true");
	else
		timeformat->setDisabled("true");
}

void AxesDialog::axisEnabled(bool on) {
	int item = axeslb->currentItem();
	if (on) {	// axis is to be enabled
		plot->enableBorder(item,true);
		cb6->setChecked(true);
		// TODO : show the label position in richtext widget (rtw)
		rtw->setLabel(axis[item]->label());
	}
}

//! update the selected axis
void AxesDialog::updateAxis() {
	int item = axeslb->currentItem();
	cb->setChecked(axis[item]->enabled());

	rtw->setLabel(axis[item]->label());

	scaling->setText(QString::number(axis[item]->Scaling()));
	shift->setText(QString::number(axis[item]->Shift()));

	if (type == P2D || type == PSURFACE || type == PPOLAR) {
		if(item == 0 || item == 3) {
			min->setText(QString::number(plot->ActRanges()[0].rMin()));
			max->setText(QString::number(plot->ActRanges()[0].rMax()));

			ascb->setCurrentItem(axis[0]->Scale());
			if (type == PPOLAR) {
				//min->setEnabled(FALSE);
				max->setEnabled(FALSE);
			}
		}
		else if (item == 1 || item == 2) {
			min->setText(QString::number(plot->ActRanges()[1].rMin()));
			max->setText(QString::number(plot->ActRanges()[1].rMax()));

			ascb->setCurrentItem(axis[1]->Scale());
			if (type == PPOLAR) {
				//min->setEnabled(TRUE);
				max->setEnabled(TRUE);
			}
		}
	}
	else if (type == P3D || type == PQWT3D){
		if(item == 0 || item == 3 || item == 6 || item == 9) {
			min->setText(QString::number(plot->ActRanges()[0].rMin()));
			max->setText(QString::number(plot->ActRanges()[0].rMax()));
		}
		else if (item == 1 || item == 4 || item == 7 || item == 10) {
			min->setText(QString::number(plot->ActRanges()[1].rMin()));
			max->setText(QString::number(plot->ActRanges()[1].rMax()));
		}
		else if (item == 2 || item == 5 || item == 8 || item == 11) {
			min->setText(QString::number(plot->ActRanges()[2].rMin()));
			max->setText(QString::number(plot->ActRanges()[2].rMax()));
		}
	}

	// tics
	cb2->setChecked(axis[item]->MajorTicsEnabled());
	cb3->setChecked(axis[item]->MinorTicsEnabled());
	major->setText(QString::number(axis[item]->MajorTics()));
	minor->setText(QString::number(axis[item]->MinorTics()));

	tf = axis[item]->TicsFont();
	ticsfont->setText(tf.family() + tr(" ") + QString::number(tf.pointSize()));

	tlprefix->setText(axis[item]->TicsLabelPrefix());
	tlsuffix->setText(axis[item]->TicsLabelSuffix());

	tcb->setColor(axis[item]->TicsColor());
	tlcb->setColor(axis[item]->TicsLabelColor());

	ticsposcb->setCurrentItem(axis[item]->TicsPos());
	atlfcb->setCurrentItem(axis[item]->TicsLabelFormat());
	tlple->setText(QString::number(axis[item]->TicsLabelPrecision()));
	tlgle->setText(QString::number(axis[item]->TicsLabelGap()));
	timeformat->setText(axis[item]->DateTimeFormat());
	if (atlfcb->currentText() == i18n("time"))
		timeformat->setEnabled("true");
	tlrotation->setText(QString::number(axis[item]->TicsLabelRotation()));

	// grid
	cb4->setChecked(plot->gridEnabled(2*item));
	cb5->setChecked(plot->gridEnabled(2*item+1));
	gcb->setColor(axis[item]->GridColor());
	bcb->setColor(axis[item]->BorderColor());

	cb6->setChecked(plot->borderEnabled(item));
}

void AxesDialog::selectTicsFont() {
    bool ok;
    QFont font = QFontDialog::getFont( &ok,
		    axis[axeslb->currentItem()]->TicsFont(), this );
    if ( ok ) {
	tf = font;
	ticsfont->setText(tf.family() + tr(" ") + QString::number(tf.pointSize()));
    }
}

void AxesDialog::apply_clicked() {
	int item = axeslb->currentItem();

	// change xmin,etc. if somethings changed
	if(cb->isChecked() != axis[item]->enabled())
		plot->setBorder(item,cb->isChecked());
	axis[item]->enable(cb->isChecked());

	axis[item]->setLabel(rtw->label());

	axis[item]->setScaling(scaling->text().toDouble());
	axis[item]->setShift(shift->text().toDouble());

	axis[item]->setTicsLabelPrefix(tlprefix->text());
	axis[item]->setTicsLabelSuffix(tlsuffix->text());

	axis[item]->setTicsFont(tf);
	axis[item]->setTicsColor(tc);
	axis[item]->setTicsLabelColor(tlc);
	axis[item]->setGridColor(gc);
	axis[item]->setBorderColor(bc);

	axis[item]->setTicsPos(ticsposcb->currentItem());
	axis[item]->setTicsLabelFormat((TFormat)atlfcb->currentItem());
	axis[item]->setTicsLabelPrecision(tlple->text().toInt());
	axis[item]->setTicsLabelGap(tlgle->text().toInt());
	axis[item]->setDateTimeFormat(timeformat->text());
	axis[item]->setTicsLabelRotation(tlrotation->text().toDouble());

	if((TScale)(ascb->currentItem()) != LINEAR && parse((char *) (min->text()).latin1()) <= 0) {
		if ((TScale)(ascb->currentItem()) != SQRT || parse((char *) (min->text()).latin1()) < 0) {
			KMessageBox::warningContinueCancel(this,
				i18n("The axes range has negative values!\nResetting minimum value."));
			if ((TScale)(ascb->currentItem()) == SQRT)
				min->setText(QString("0"));
			else
				min->setText(QString("0.01"));
		}
	}

	if (type == P2D || type == PSURFACE || type == PPOLAR) {
		if (item == 0 || item == 3 ) {
			plot->setXRange(parse((char *)(min->text()).latin1()),
				parse((char *)(max->text()).latin1()));
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());

			axis[0]->setScale((TScale)ascb->currentItem());
			if (type != PPOLAR) {
				if (item == 0)
					axis[3]->setGridColor(axis[0]->GridColor());
				else
					axis[0]->setGridColor(axis[3]->GridColor());
				axis[3]->setScale((TScale)ascb->currentItem());
			}
		}
		else if (item == 1 || item == 2){
			plot->setYRange(parse((char *)(min->text()).latin1()),
				parse((char *)(max->text()).latin1()));
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());

			axis[1]->setScale((TScale)ascb->currentItem());
			
			if (type != PPOLAR) {			
				if (item == 1)
					axis[2]->setGridColor(axis[1]->GridColor());
				else
					axis[1]->setGridColor(axis[2]->GridColor());
				axis[2]->setScale((TScale)ascb->currentItem());
			}
		}
		plot->enableGrid(2*item,cb4->isChecked());
		plot->enableGrid(2*item+1,cb5->isChecked());
	}
	else if (type == P3D || type == PQWT3D) {
		plot->enableGrid(2*item,cb4->isChecked());
		plot->enableGrid(2*item+1,cb5->isChecked());

		if (item == 0 || item == 3 || item == 6 || item == 9) {
			plot->setXRange(parse((char *)(min->text()).latin1()),
				parse((char *)(max->text()).latin1()));

			axis[0]->setScale((TScale)ascb->currentItem());
			
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
		else if (item == 1 || item == 4 || item == 7 || item == 10) {
			plot->setYRange(parse((char *)(min->text()).latin1()),
				parse((char *)(max->text()).latin1()));

			axis[1]->setScale((TScale)ascb->currentItem());
			
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
		else if (item == 2 || item == 5 || item == 8 || item == 11) {
			plot->setZRange(parse((char *)(min->text()).latin1()),
				parse((char *)(max->text()).latin1()));

			axis[2]->setScale((TScale)ascb->currentItem());

			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
	}

	plot->enableBorder(item,cb6->isChecked());
	p->updatePixmap();
}

void AxesDialog::ok_clicked() {
	apply_clicked();
	accept();
}
