//LabPlot : Graph3D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph3D.h"

using namespace std;

Graph3D::Graph3D(QString n, QString l, LRange r[3], LSource src, PType t, Style st, 
		Symbol sy, Point3D *p, int nrx, int nry, bool b)
	: Graph(n,l,src,t,st,sy,nrx*nry,b)
{
	//kdDebug()<<"TYPE : "<<t<<endl;
	//kdDebug()<<"TYPE : "<<type<<endl;
	//kdDebug()<<"NAME : "<<name<<endl;

	range = new LRange[3];
	if(r) {
		for(int i=0;i<3;i++) {
			range[i]=r[i];
		}
	}
	numberx=nrx;
	numbery=nry;
	number=nrx*nry;

	ptr = new Point3D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];
}

void Graph3D::save(QTextStream *t) {
	saveGraph(t);
	*t<<numberx<<' '<<numbery<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<' ';
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<' '<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< numberx*numbery;i++) {
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<endl;
	}
}

void Graph3D::open(QTextStream *t, int version) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>numberx>>numbery;
	else if (version > 1)
		*t>>name>>label>>numberx>>numbery;
	else
		*t>>name>>numberx>>numbery;

	kdDebug()<<"Graph3D : "<<name<<' '<<label<<' '<<numberx<<' '<<numbery<<endl;

	number=numberx*numbery;

	double xmin, xmax, ymin, ymax, zmin, zmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	double x, y, z;
	ptr = new Point3D[numberx*numbery];
	for (int i=0;i< numberx*numbery;i++) {
		*t>>x>>y>>z;
		ptr[i].setPoint(x,y,z);

		kdDebug()<<x<<' '<<y<<' '<<z<<endl;
	}
}

QStringList Graph3D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PTERNARY)
		t=i18n("Ternary");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(numberx) << QString::number(numbery);
	s << QString::number(range[0].rMin()) + " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());
	
	return s;
}

// calcuate error range for xydy graph3d
LRange Graph3D::ErrorDYRange() {
	double min=0,max=0;
	double y,z;
	for(int i=0;i<numberx;i++) {
		y=ptr[i].Y();
		z=ptr[i].Z();
		if(i==0) {
			min=y-z;
			max=y+z;
		}
		else {
			y-z<min?min=y-z:0;
			y+z>max?max=y+z:0;
		}
	}

	return LRange(min,max);
}
