//LabPlot : PlotSettingsDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "PlotSettingsDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "ColormapReader.h"

const QString plotStyle[]={"NOPLOT","WIREFRAME","HIDDENLINE","FILLED","FILLEDMESH","POINTS","USER",0};
#define NR_PLOTSTYLE 7
const QString coordinateStyle[]={"NOCOORD","BOX","FRAME",0};
#define NR_COORDINATESTYLE 3
const QString floorStyle[]={"NOFLOOR","FLOORISO","FLOORDATA",0};
#define NR_FLOORSTYLE 3


//! for general plot settings
PlotSettingsDialog::PlotSettingsDialog(Worksheet *p, const char *name)
	: Dialog(p, name)
{
	plot = p->getPlot(p->API());
	type = plot->Type();
	setCaption(i18n("Plot Settings")+i18n(" : ")+QString(name));

	QGroupBox *gb;
	QHBox *hb;
	if(type != PQWT3D) {
		gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
		hb = new QHBox(gb);
		new QLabel(i18n("Plot Position : "),hb);
		posx = new KLineEdit(QString::number(plot->Position().X()),hb);
		posx->setValidator(new QDoubleValidator(0,1,3,posx));
		new QLabel(i18n(" , "),hb);
		posy = new KLineEdit(QString::number(plot->Position().Y()),hb);
		posy->setValidator(new QDoubleValidator(0,1,3,posy));
		hb = new QHBox(gb);
		new QLabel(i18n("Plot Size : "),hb);
		sizex = new KLineEdit(QString::number(plot->Size().X()),hb);
		sizex->setValidator(new QDoubleValidator(0,1,3,sizex));
		new QLabel(i18n(" , "),hb);
		sizey = new KLineEdit(QString::number(plot->Size().Y()),hb);
		sizey->setValidator(new QDoubleValidator(0,1,3,sizey));

		gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Ranges"),vbox);
		hb = new QHBox(gb);
		KPushButton *asx = new KPushButton(i18n("Autoscale x"),hb);
		QObject::connect(asx,SIGNAL(clicked()),SLOT(autoscalex()));
		KPushButton *asy = new KPushButton(i18n("Autoscale y"),hb);
		QObject::connect(asy,SIGNAL(clicked()),SLOT(autoscaley()));
		if (type == P3D) {
			KPushButton *asz = new KPushButton(i18n("Autoscale z"),hb);
			QObject::connect(asz,SIGNAL(clicked()),SLOT(autoscalez()));
		}
		LRange *r = plot->ActRanges();
		hb = new QHBox(gb);
		new QLabel(i18n("x = "),hb);
		xmin = new KLineEdit(QString::number(r[0].rMin()),hb);
		xmin->setValidator(new QDoubleValidator(xmin));
		new QLabel(i18n(" .. "),hb);
		xmax = new KLineEdit(QString::number(r[0].rMax()),hb);
		xmax->setValidator(new QDoubleValidator(xmax));
		hb = new QHBox(gb);
		new QLabel(i18n("y = "),hb);
		ymin = new KLineEdit(QString::number(r[1].rMin()),hb);
		ymin->setValidator(new QDoubleValidator(ymin));
		new QLabel(i18n(" .. "),hb);
		ymax = new KLineEdit(QString::number(r[1].rMax()),hb);
		ymax->setValidator(new QDoubleValidator(ymax));

		if (type == P3D) {
			hb = new QHBox(gb);
			new QLabel(i18n("z = "),hb);
			zmin = new KLineEdit(QString::number(r[2].rMin()),hb);
			zmin->setValidator(new QDoubleValidator(zmin));
			new QLabel(i18n(" .. "),hb);
			zmax = new KLineEdit(QString::number(r[2].rMax()),hb);
			zmax->setValidator(new QDoubleValidator(zmax));
		}

		hb = new QHBox(gb);
		new QLabel(i18n("clipping offset : "),hb);
		cliple = new KLineEdit(QString::number(plot->ClipOffset()),hb);
		cliple->setValidator(new QIntValidator(cliple));
	}
	
	gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
	hb = new QHBox(gb);
	transparentcb = new QCheckBox(i18n("transparent plot"),hb);
	transparentcb->setChecked(plot->Transparent());

	hb = new QHBox(gb);
	new QLabel(i18n("Background Color : "),hb);
	bgcolor = new KColorButton(plot->Background(),hb);

	hb = new QHBox(gb);
	new QLabel(i18n("Graph Background Color : "),hb);
	gbgcolor = new KColorButton(plot->graphBackground(),hb);

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
	hb = new QHBox(gb);
	if(type != PQWT3D) {
		baselinecb = new QCheckBox(i18n("draw Baseline "),hb);
		baselinecb->setChecked(plot->baselineEnabled());
		new QLabel(i18n("Baseline @ y = "),hb);
		baselinele = new KLineEdit(QString::number(plot->Baseline()),hb);
		baselinele->setValidator(new QDoubleValidator(baselinele));

		hb = new QHBox(gb);
		regioncb = new QCheckBox(i18n("draw Region "),hb);
		regioncb->setChecked(plot->regionEnabled());
		new QLabel(i18n("x = "),hb);
		regionminle = new KLineEdit(QString::number(plot->RegionMin()),hb);
		regionminle->setValidator(new QDoubleValidator(regionminle));
		new QLabel(i18n(" .. "),hb);
		regionmaxle = new KLineEdit(QString::number(plot->RegionMax()),hb);
		regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
	}
#ifdef HAVE_GL
	else {
		aspectratio = new QCheckBox(i18n("Aspect ratio "),hb);
		aspectratio->setChecked(((PlotQWT3D *) plot)->aspectRatio());
		
		hb = new QHBox(gb);
		new QLabel(i18n("Plot Style : "),hb);
		plotstyle = new KComboBox(hb);
        	QStringList plotstylelist;
		for(int i=0;i<NR_PLOTSTYLE;i++)
			plotstylelist<<plotStyle[i];
        	plotstyle->insertStringList(plotstylelist);
		plotstyle->setCurrentItem(((PlotQWT3D *) plot)->PlotStyle());
		
		hb = new QHBox(gb);
		new QLabel(i18n("Coordinate Style : "),hb);
		coordinatestyle = new KComboBox(hb);
        	QStringList coordinatestylelist;
		for(int i=0;i<NR_COORDINATESTYLE;i++)
			coordinatestylelist<<coordinateStyle[i];
        	coordinatestyle->insertStringList(coordinatestylelist);
		coordinatestyle->setCurrentItem(((PlotQWT3D *) plot)->CoordinateStyle());
		
		hb = new QHBox(gb);
		new QLabel(i18n("Floor Style : "),hb);
		floorstyle = new KComboBox(hb);
        	QStringList floorstylelist;
		for(int i=0;i<NR_FLOORSTYLE;i++)
			floorstylelist<<floorStyle[i];
        	floorstyle->insertStringList(floorstylelist);
		floorstyle->setCurrentItem(((PlotQWT3D *) plot)->FloorStyle());
		
		hb = new QHBox(gb);
		new QLabel(i18n("isolines = "),hb);
		isolines = new KLineEdit(QString::number(((PlotQWT3D *) plot)->isolines()),hb);
		isolines->setValidator(new QIntValidator(isolines));
		
		hb = new QHBox(gb);
		KPushButton *colormap = new KPushButton(i18n("Colormap"),hb);
		QObject::connect(colormap,SIGNAL(clicked()),SLOT(selectColormap()));
	}
#endif
	
	if (type == PSURFACE) {
		// TODO
		//surfaceStyle();
	}
	else {
		// TODO : simpleStyle(...); ?
	}

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PlotSettingsDialog::selectColormap() {
	ColorMapPreview *colormap = new ColorMapPreview;
	QFileDialog *datacolor = new QFileDialog(this);

	QString cmdir = locate("data","LabPlot/colormaps/");
	datacolor->setDir(cmdir);
	datacolor->setFilter("Colormap files (*.map;*.MAP)");
	datacolor->setContentsPreviewEnabled( TRUE );
	datacolor->setContentsPreview( colormap, colormap);
	datacolor->setPreviewMode( QFileDialog::Contents );

	connect(datacolor, SIGNAL(fileHighlighted(const QString&)), this, SLOT(adaptDataColors(const QString&)));
	datacolor->show();
}

void PlotSettingsDialog::adaptDataColors(const QString& fn) {
#ifdef HAVE_GL
	if (!openColorMap(fn))
		return;

	Qwt3D::StandardColor *col = new Qwt3D::StandardColor((PlotQWT3D *)plot);
	col->setColorVector(cv);

	((PlotQWT3D *) plot)->setColorVector(cv);
#endif
}

bool PlotSettingsDialog::openColorMap(QString fn) {
#ifdef HAVE_GL
	kdDebug()<<"openColorMap("<<fn<<")"<<endl;
	ifstream file((const char*)fn.local8Bit());

	if (!file) return false;

	Qwt3D::RGBA rgb;
	cv.clear();

	while ( file ) {
		file >> rgb.r >> rgb.g >> rgb.b;
		file.ignore(1000,'\n');
		if (!file.good())
			break;
		else {
			rgb.a = 1;
			rgb.r /= 255;
			rgb.g /= 255;
			rgb.b /= 255;
			cv.push_back(rgb);
		}
	}

	return true;
#endif
}

void PlotSettingsDialog::apply_clicked() {
	plot->setBackground(bgcolor->color());
	plot->setGraphBackground(gbgcolor->color());
	plot->setTransparent(transparentcb->isChecked());
	
	if(type != PQWT3D) {
		plot->setPosition(posx->text().toDouble(),posy->text().toDouble());
		plot->setSize(sizex->text().toDouble(),sizey->text().toDouble());
	
		plot->setClipOffset(cliple->text().toInt());
		plot->setXRange(xmin->text().toDouble(),xmax->text().toDouble());
		plot->setYRange(ymin->text().toDouble(),ymax->text().toDouble());
		if (type == P3D)
			plot->setZRange(zmin->text().toDouble(),zmax->text().toDouble());
	
		if (type == PSURFACE) {
			((Plot2DSurface * )plot)->enableDensity(dcb->isChecked());
			((Plot2DSurface * )plot)->enableContour(ccb->isChecked());
			((Plot2DSurface * )plot)->setNumber(numberle->text().toInt());
			((Plot2DSurface * )plot)->setPalette(pcb->currentItem());
		}
	
		plot->setBaseline(baselinele->text().toDouble());
		plot->setBaselineEnabled(baselinecb->isChecked());
		
		plot->setRegionMin(regionminle->text().toDouble());
		plot->setRegionMax(regionmaxle->text().toDouble());
		plot->setRegionEnabled(regioncb->isChecked());
	}
#ifdef HAVE_GL
	else {	// PQWT3D
		((PlotQWT3D *) plot)->setPlotStyle((Qwt3D::PLOTSTYLE) plotstyle->currentItem());
		((PlotQWT3D *) plot)->setCoordinateStyle((Qwt3D::COORDSTYLE) coordinatestyle->currentItem());
		((PlotQWT3D *) plot)->setFloorStyle((Qwt3D::FLOORSTYLE) floorstyle->currentItem());
		((PlotQWT3D *) plot)->setIsolines(isolines->text().toInt());
		((PlotQWT3D *) plot)->setAspectRatio(aspectratio->isChecked());
	}
#endif
	
	p->updatePixmap();
}

void PlotSettingsDialog::autoscalex() { 
	plot->autoScaleX();
	LRange *r = plot->Ranges();
	xmin->setText(QString::number(r[0].rMin()));
	xmax->setText(QString::number(r[0].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoscaley() { 
	plot->autoScaleY();
	LRange *r = plot->Ranges();
	ymin->setText(QString::number(r[1].rMin()));
	ymax->setText(QString::number(r[1].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoscalez() { 
	plot->autoScaleZ();
	LRange *r = plot->Ranges();
	zmin->setText(QString::number(r[2].rMin()));
	zmax->setText(QString::number(r[2].rMax()));
	p->updatePixmap();
}
