#!/bin/sh
# a program to (hopefully) figure out what your domain name is

# 1. use the environment: $DOMAIN and $DOMAINNAME is the best
if [ "X$DOMAIN" != "X" ]; then
	echo "$DOMAIN"
	exit 0
fi
if [ "X$DOMAINNAME" != "X" ]; then
	echo "$DOMAINNAME"
	exit 0
fi

# 1. if a mailer is on this machine, let's try it's configuration
x=`cat /var/qmail/control/defaultdomain`
if [ "X$x" != "X" ]; then
	echo "$x"
	exit 0
fi

# 2. /etc/resolv.conf may contain a "domain" entry.
x=`egrep '^domain' /etc/resolv.conf | awk '{ print $2 }'`
if [ "X$x" != "X" ]; then
	echo "$x"
	exit 0
fi

# 3. dnsdomainname and domainname are specific to linuxish and nis systems
# nevertheless: we are hopeful... (Chris Jantzen)
x=`(dnsdomainname || domainname || nisdomainname) 2>/dev/null 2>&1`
if [ "X$x" != "X" ]; then
	if [ "X$x" != "X(none)" ]; then
		echo "$x"
		exit 0
	fi
fi

# 4. under solaris, the first "record" in /etc/hosts that isn't loopback
# is the local machine. we strip off the host part and pray it's right.
x=`sed -e 's/#.*//' /etc/hosts | egrep '\.' | egrep -v '^127\.0\.0\.1[ 	]' | head -1 | awk '{ for (I = 2; I <= NF; I++) { if ($I ~ /\./) { print $I } } }' | sort -u | head -1 | sed -e 's/^[^\.]*\.//'`
if [ "X$x" != "X" ]; then
	echo "$x"
	exit 0
fi

# 5. HP/UX and AIX show FQDN in "hostname" (Simon Matter)
x=`hostname`
y=`echo -n "$x" | sed -e 's/[^\.]*//g' | wc -c | sed -e 's/[^0-9]//g'`
if [ "X$y" != "X0" ]; then
	# okay... x may contain our domain name... let's hope it gets mail
	echo "$x"
	exit 0
fi

# unknown
echo '(none)'
exit 1
