/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <panel.h>
#include <time.h>
#include <sys/time.h>
#include "curse.h"
#include "error.h"
#include "debug.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "srpref.h"
#include "p2open.h"

#define	DEMOUSER	"demouser"

RCFILE	NullRcFile[] =
{
	{ "streamer",	"none",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ NULL }
};


RCFILE	AdvFnRcFile[] =
{
	{ "streamer",	"advfn.com(uk)",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "advfn.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "advfn.com streamer password"},
	{ "netname",	"advfn.com",
			RC_STR, 1, 64,
			"advfn network, e.g. advfn.com or advfn.fr"},
	{ NULL }
};

RCFILE	AdvFnFrRcFile[] =
{
	{ "streamer",	"advfn.fr",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "advfn.fr streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "advfn.fr streamer password"},
	{ "netname",	"advfn.fr",
			RC_STR, 1, 64,
			"advfn network, e.g. advfn.com or advfn.fr"},
	{ NULL }
};

RCFILE	AmeritradeRcFile[] =
{
	{ "streamer",	"ameritrade.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "ameritrade.com username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "ameritrade.com password"},
	{ "auth-age",	"12",
			RC_NUM, 0, 168, "hours until next re-authentication"},
	{ "hostname",	"investment.datek.com",
			RC_STR, 1, 64, "ameritrade.com IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "ameritrade.com port number"},
	{ NULL }
};

RCFILE  FreetradeRcFile[] =
{
        { "streamer",   "freetrade.com",
                        RC_STR, 0, 64,
                "Streamer type; press c or left/right arrows to change"},
        { "username",   DEMOUSER,
                        RC_STR, 0, 64, "freetrade.com username"},
        { "password",   "XXXXXX",
                        RC_PASS, 0, 64, "freetrade.com password"},
        { "auth-age",   "12",
                        RC_NUM, 0, 168, "hours until next re-authentication"},
        { "hostname",   "investment.datek.com",
                        RC_STR, 1, 64, "freetrade.com IP address/hostname"},
        { "port",       "80",
                        RC_NUM, 0, 65535, "freetrade.com port number"},
        { NULL }
};

RCFILE	DatekRcFile[] =
{
	{ "streamer",	"datek.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "datek.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "datek.com streamer password"},
	{ "encpasswd",	"990E6557B533B6529B661187127FD9A0035BB3C0",
			RC_PASS, 0, 64,
			"datek.com hashed password (computed from password)"},
	{ "hostname",	"streamerapp.datek.com",
			RC_STR, 1, 64, "datek.com IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "datek.com port number"},
	{ NULL }
};

RCFILE	EsignalRcFile[] =
{
	{ "streamer",	"esignal.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "esignal.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "esignal.com streamer password"},
	{ "usecharts",	"1",
			RC_NUM, 0, 1,
			"1 = Use esignal.com charts, "
			"0 = Use <fill_charts> charts",
			},
	{ "port",	"2812",
			RC_NUM, 0, 65535, "esignal.com port number"},
	{ NULL }
};

RCFILE	MoneyAmRcFile[] =
{
	{ "streamer",	"moneyam.com(uk)",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "quotemedia.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "quotemedia.com streamer password"},
	{ "lastIsMid",	"1",
			RC_NUM, 0, 1, "LAST displays the Mid price"},
	{ NULL }
};

RCFILE	MoneynetRcFile[] =
{
	{ "streamer",	"money.net",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "money.net streamer username"},
	{ "password",	"demopw",
			RC_PASS, 0, 64, "money.net streamer password"},
	{ "encpasswd",	"TqYNfQ3zZDYMzDgZ3DyUnUj3WOYM5DxQNMGxzNVOEiW",
			RC_PASS, 0, 64,
			"money.net hashed password (computed from password)"},
	{ "hostname",	"rtdata.money.net",
			RC_STR, 1, 64, "money.net IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "money.net port number"},
	{ NULL }
};

RCFILE	QuotemediaRcFile[] =
{
	{ "streamer",	"quotemedia.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "quotemedia.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "quotemedia.com streamer password"},
	{ "hostname",	"www.quotemedia.com",
			RC_STR, 1, 64, "quotemedia.com IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "quotemedia.com port number"},
	{ NULL }
};

RCFILE	SchwabRcFile[] =
{
	{ "streamer",	"schwab.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "schwab.com account number"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "schwab.com password"},
	{ "software",	"Velocity|Streetsmart Pro|Cybertrader",
			RC_LIST, 1, 64,
			"Software that Schwab has authorized me to use"},
	{ "usecharts",	"1",
			RC_NUM, 0, 1,
			"1 = Use schwab.com charts, "
			"0 = Use <fill_charts> charts",
			},
	{ "useL2",	"1",
			RC_NUM, 0, 1,
			"1 = Use schwab.com L2 feed, "
			"0 = Use backup L2 feed (quotemedia.com)"
			},
	{ "usenews",	"1",
			RC_NUM, 0, 1,
			"1 = Use schwab.com newsfeed, "
			"0 = Use backup news feed"
			},
	{ "hotnews",	"1",
			RC_NUM, 0, 1, "1 = Display hot news items"},
	{ "hotinclude",	"",
			RC_STR, 0, 64, "RE|RE|RE of hot headlines to include"},
	{ "hotexclude",	"",
			RC_STR, 0, 64, "RE|RE|RE of hot headlines to exclude"},
#if 0
	// News stopped working with this server 01/2003
	{ "hostname",	"vsqn.cybertrader.com",
			RC_STR, 1, 64, "schwab.com IP address/hostname"},
#endif
	{ "hostname",	"63.82.178.8",
			RC_STR, 1, 64,
			"schwab.com IP address/hostname"},
	{ "port",	"1007",
			RC_NUM, 0, 65535,
			"schwab.com port number"},
	{ "auxname",	"63.82.176.62",
			RC_STR, 1, 64,
			"schwab.com top10 IP address/hostname"},
	{ "auxport",	"1040",
			RC_NUM, 0, 65535,
			"schwab.com top10 port number"},
	{ "chartname",	"63.82.178.10",
			RC_STR, 1, 64,
			"schwab.com chart server IP address/hostname"},
	{ "chartport",	"2007",
			RC_NUM, 0, 65535,
			"schwab.com chart server port number"},
	{ NULL }
};

RCFILE	ScottraderRcFile[] =
{
	{ "streamer",	"scottrader.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "scottrader.com streamer username"},
	{ "password",	DEMOPW,
			RC_PASS, 0, 64, "scottrader.com streamer password"},
	{ "usecharts",	"0",
			RC_NUM, 0, 1, "1 = Use scottrader charts"},
	{ "usechains",	"0",
			RC_NUM, 0, 1, "1 = Use scottrader option chains"},
	{ "refreshmode",	"1",
			RC_NUM, 0, 2,
			"Periodic symbol refresh: 0=never 1=indexes 2=all"},
	{ "hostname",
			// "63.240.138.21",
			"12.151.52.140",
			RC_STR, 1, 64, "scottrader.com IP address/hostname"},
	{ "port",	"443",
			RC_NUM, 0, 65535, "scottrader.com port number"},
	{ NULL }
};

RCFILE	SonictradingRcFile[] =
{
	{ "streamer",	"sonictrading.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "sonictrading.com streamer username"},
	{ "password",	"demopw",
			RC_PASS, 0, 64, "sonictrading.com streamer password"},
	{ "hostname",	"download.sonictrading.com",
			RC_STR, 1, 64, "sonictrading.com IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "sonictrading.com port number"},
	{ NULL }
};


RCFILE	SwissquoteRcFile[] =
{
	{ "streamer",	"swissquote.ch",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "swissquote.ch streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "swissquote.ch streamer password"},
	{ "hostname",	"premium.swissquote.ch",
			RC_STR, 1, 64, "swissquote.ch IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "swissquote.ch port number"},
	{ NULL }
};

RCFILE	YahooRcFile[] =
{
	{ "streamer",	"yahoo.com",
			RC_STR, 0, 64,
		"Streamer type; press c or left/right arrows to change"},
	{ "username",	DEMOUSER,
			RC_STR, 0, 64, "yahoo.com streamer username"},
	{ "password",	"XXXXXX",
			RC_PASS, 0, 64, "yahoo.com streamer password"},
	{ "hostname",	"markettracker.finance.yahoo.com",
			RC_STR, 1, 64, "yahoo.com IP address/hostname"},
	{ "port",	"80",
			RC_NUM, 0, 65535, "yahoo.com port number"},
	{ NULL }
};

SRLIST	SrList[] =
{
	{ "none",		NullRcFile,
				null_new,
				"/dev/null"
	},
	{ "scottrader.com",	ScottraderRcFile,
				scottrader_new,
				"." PROGNAMESTR "/scottrader.com"
	},
	{ "ameritrade.com",	AmeritradeRcFile,
				ameritrade_new,
				"." PROGNAMESTR "/ameritrade.com"
	},
	{ "datek.com",		DatekRcFile,
				datek_new,
				"." PROGNAMESTR "/datek.com"
	},
	{ "esignal.com",	EsignalRcFile,
				esignal_new,
				"." PROGNAMESTR "/esignal.com"
	},
	{ "freetrade.com",	FreetradeRcFile,
				freetrade_new,
				"." PROGNAMESTR "/freetrade.com"
	},
	{ "money.net",		MoneynetRcFile,
				moneynet_new,
				"." PROGNAMESTR "/money.net"
	},
	{ "quotemedia.com",	QuotemediaRcFile,
				quotemedia_new,
				"." PROGNAMESTR "/quotemedia.com"
	},
	{ "schwab.com",		SchwabRcFile,
				schwab_new,
				"." PROGNAMESTR "/schwab.com"
	},
	{ "sonictrading.com",	SonictradingRcFile,
				sonictrading_new,
				"." PROGNAMESTR "/sonictrading.com"
	},
#if 0
	{ "yahoo.com",		YahooRcFile,
				yahoo_new,
				"." PROGNAMESTR "/yahoo.com"
	},
#endif

	{ "advfn.com(uk)",	AdvFnRcFile,
				advfn_new,
				"." PROGNAMESTR "/advfn.com"
	},
	{ "advfn.fr",		AdvFnFrRcFile,
				advfn_new,
				"." PROGNAMESTR "/advfr.com"
	},
	{ "moneyam.com(uk)",	MoneyAmRcFile,
				moneyam_new,
				"." PROGNAMESTR "/moneyam.com"
	},
	{ "swissquote.ch",	SwissquoteRcFile,
				swissquote_new,
				"." PROGNAMESTR "/swissquote.ch"
	},
	{ NULL }
};

SRLIST	*SrCur;
SRLIST	*SrTmp;

SRLIST *
find_streamer(char *streamer)
{
	SRLIST		*srp;

	for (srp = SrList; srp->name; ++srp)
		if (strcmp(srp->name, streamer) == 0)
			break;

	if (!srp->name)
		srp = SrList;

	process_rc_file(srp->rcfile, srp->filename);

	return (srp);
}

char *
match_streamer(char *streamer)
{
	SRLIST		*srp;

	for (srp = SrList; srp->name; ++srp)
		if (strncmp(srp->name, streamer, strlen(streamer)) == 0)
			return srp->name;
	return "none";
}

char *
cycle_streamer(int incr)
{
	SRLIST	*srp = SrCur;
	SRLIST	*osrp;
	RCFILE	*rcp;

	if (!srp)
		srp = SrList;

	osrp = srp;

	for (srp = srp + incr; srp != osrp; srp = srp + incr)
	{
		if (srp < SrList)
			srp = SrList + asizeof(SrList) - 1;
		else if (srp->name == NULL)
			srp = SrList;
		else
		{
			char	*username;
			char	*password;

			rcp = srp->rcfile;

			process_rc_file(rcp, srp->filename);
			username = get_rc_value(rcp, "username");
			password = get_rc_value(rcp, "password");

			if (username[0] && password[0] &&
					strcmp(username, DEMOUSER))
				break;
		}
	}
	return (srp->name);
}

//
// Sr Prefs popup - incomplete
//

static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;
static RCFILE	*Rcp;

static int	Cursor;
static int	Top;
static int	NumPrefs;

static char	Choice[8][64];
static int	NumChoice = 0;
static int	CurChoice = 0;
static int	ShowPassword = 0;

static void
display_pref_line(RCFILE *rcp, int y, int hilite)
{
	char	*str;
	char	stars[256];

	if (!rcp || !rcp->name || !rcp->value)
	{
		mvwprintw(Subwin, y, 0, "%-16.16s  %-*.*s",
			"",
			getmaxx(Subwin) - 16 - 2,
			getmaxx(Subwin) - 16 - 2,
			"");
		return;
	}

	if (hilite)
		wattrset(Subwin, A_REVERSE);

	if (rcp->type == RC_PASS && !ShowPassword)
	{
		memset(stars, '*', strlen(rcp->value));
		stars[strlen(rcp->value)] = 0;
		str = stars;
	}
	else
		str = rcp->value;

	mvwprintw(Subwin, y, 0, "%-16.16s  %-*.*s",
		rcp->name,
		getmaxx(Subwin) - 16 - 2,
		getmaxx(Subwin) - 16 - 2,
		str);
	wattrset(Subwin, A_NORMAL);
}

static void
repaint_pref_lines(RCFILE *rcp)
{
	int	y;

	for (y = 0; y < getmaxy(Subwin); ++y)
	{
		display_pref_line(rcp, y, FALSE);
		if (rcp->name)
			++rcp;
	}
}

static void
display_comment(RCFILE *rcp)
{
	mvprintw(LINES-2, 0, "%-*.*s", COLS, COLS, Rcp[Cursor].comment);
}

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1, Top ? ACS_UARROW : ACS_VLINE);
	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Top+getmaxy(Subwin)) < NumPrefs ? ACS_DARROW : ACS_VLINE);
}

static void
display_sr(RCFILE *rcp)
{
	int	y;

	wclear(Subwin);
	y = 0;
	NumPrefs = 0;
	while (rcp->name)
	{
		if (rcp->value == NULL)
		{
			rcp->value = strdup(rcp->defvalue);
			if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
			{
				char    *p = strchr(rcp->value, '|');
				if (p) *p = 0;
			}
		}
		if (y < getmaxy(Subwin))
		{
			display_pref_line(rcp, y, y == 0);
			++y;
		}
		++rcp;
		++NumPrefs;
	}
}

void
srpref_popup(void)
{
	int	y;
	RCFILE	*rcp;
	int	cols;

#if 0
	// Count entries
	for (y = 0; rcp[y].name; ++y)
		{}
#else
	y = 13;
#endif

	y += 2;		// Account for 2 lines of help
	y += 2;		// Account for box

	if (y > (LINES-2)) y = (LINES-2);
	Win = newwin(y, cols80(), LINES - 2 - y, 0);
	// Win = bestwin(y);
	if (!Win)
		error(1, "Can't create pref window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);
	wclear(Win);

	box(Win, 0, 0);
	mvwcenter(Win, 0, " Change Streamer ");

	Subwin = derwin(Win, getmaxy(Win) - 2 - 2, cols - 2, 1, 1);
	if (!Subwin)
		error(1, "Can't create srpref subwindow\n");

	Panel = new_panel(Win);

	SrTmp = SrCur;
	Rcp = rcp = SrTmp->rcfile;

	display_sr(rcp);

	mvwprintw(Win, getmaxy(Win)-2, 2,
		"c=Change  f=Reset to Factory  F=Reset All  s=Save  q=Quit"
		"  ^p=ShowPass"
		);

	blankrect(LINES-2, 0, LINES-1, COLS-1, 0);
	Cursor = 0;
	Top = 0;

	display_comment(&Rcp[Cursor]);
	display_more();
	touchwin(Win);
	update_panels(); refresh(); // doupdate();
}

static void
get_encpasswd(void)
{
	FILE	*fp[2];
	char	buf[BUFSIZ];
	char	*p;
	int	rc;
	char	*cmd = PROGNAMESTR ".auth ";

	attrset(A_BOLD);
	mvprintw(LINES-1, 0,
		"*** Please Wait - getting hashed password from website");
	attrset(A_NORMAL);
	update_panels(); refresh(); // doupdate();

	sprintf(buf, "%s %s", cmd, Rcp[0].value);
	rc = p2open("/bin/sh", buf, fp);
	if (rc < 0)
	{
		set_rc_value(Rcp, Rcp[Cursor+1].name, "cannot determine");
		display_pref_line(&Rcp[Cursor+1], Cursor+1, FALSE);
		return;
	}

	fprintf(fp[1], "%s\n", get_rc_value(Rcp, "username"));
	fprintf(fp[1], "%s\n", get_rc_value(Rcp, "password"));
	fflush(fp[1]);

	strcpy(buf, "couldn't run " PROGNAMESTR ".auth");
	fgets(buf, sizeof(buf), fp[0]);

	rc = p2close(fp);
	if (rc < 0)
	{
		set_rc_value(Rcp, Rcp[Cursor+1].name, "cannot determine2");
		display_pref_line(&Rcp[Cursor+1], Cursor+1, FALSE);
		return;
	}

	p = strchr(buf, '\n');
	if (p) *p = 0;
	set_rc_value(Rcp, Rcp[Cursor+1].name, buf);
	display_pref_line(&Rcp[Cursor+1], Cursor+1, FALSE);

	blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
}

static char	ChBuf[256];
static char	*ChPtr;
static int	PromptEndX;

static int
valid(RCFILE *rcp, char *str)
{
	if (rcp->type == RC_NUM)
	{
		int val = atoi(str);

		if (val < rcp->min || val > rcp->max)
			return 0;
	}
	else
	{
		int	len = strlen(str);

		if (len < rcp->min || len > rcp->max)
			return 0;
	}
	return 1;
}

static void
show_change(RCFILE *rcp)
{
	char	*str;
	char	stars[256];

	move(LINES-1, PromptEndX);
	if (rcp->type == RC_PASS && !ShowPassword)
	{
		memset(stars, '*', strlen(ChBuf));
		stars[strlen(ChBuf)] = 0;
		str = stars;
	}
	else
		str = ChBuf;
	printw("%-*.*s", COLS - PromptEndX - 1, COLS - PromptEndX - 1, str);
	CursorX = PromptEndX + (ChPtr - ChBuf);
}

static void
make_choice_list(RCFILE *rcp)
{
	char	*b, *e;

	NumChoice = 0;
	CurChoice = 0;
	for (b = e = Rcp[Cursor].defvalue; *e; b = e + 1)
	{
		e = strchr(b, '|');
		if (!e) e = strchr(b, 0);
		memcpy(Choice[NumChoice], b, e - b);
		Choice[NumChoice][e-b] = 0;
		if (strcmp(Choice[NumChoice], rcp->value) == 0)
			CurChoice = NumChoice;
		++NumChoice;
	}
	if (rcp->type == RC_COMBO)
	{
		strcpy(Choice[NumChoice], rcp->value);
		CurChoice = NumChoice;
		++NumChoice;
	}
}

static int NewChange;

static void
start_change(RCFILE *rcp)
{
	strcpy(ChPtr = ChBuf, rcp->value);
	NumChoice = 0;
	CurChoice = 0;

	switch (rcp->type)
	{
	case RC_NUM:
		mvprintw(LINES-1, 0, "Number (%d-%d): ", rcp->min, rcp->max);
		break;
	case RC_LIST:
		make_choice_list(rcp);
		mvprintw(LINES-1, 0, "Choice (use arrow keys): ");
		break;
	case RC_COMBO:
		make_choice_list(rcp);
		mvprintw(LINES-1, 0, "Combo (up/down/edit)): ");
		break;
	case RC_PASS:
		mvprintw(LINES-1, 0, "Password: ");
		break;
	default:
		mvprintw(LINES-1, 0, "String: ");
		break;
	}
	PromptEndX = CursorX = getcurx(stdscr);
	show_change(rcp);
	NewChange = 1;
}

static int
do_change(int c, STREAMER sr)
{
	int	y;

	switch (c)
	{
	case 033:
	abort:
		display_comment(&Rcp[Cursor]);
		blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
		CursorX = 0;
		return 1;
	case '\r':
	save:
		if (!valid(&Rcp[Cursor], ChBuf))
		{
			beep();
			return 0;
		}
		set_rc_value(Rcp, Rcp[Cursor].name, ChBuf);
		display_pref_line(&Rcp[Cursor], Cursor, TRUE);
		display_comment(&Rcp[Cursor]);
		blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
		CursorX = 0;
		if (strcmp(Rcp[Cursor].name, "password") == 0
			&& Rcp[Cursor+1].name
			&& strcmp(Rcp[Cursor+1].name, "encpasswd") == 0)
			get_encpasswd();
		touchwin(Win);
		return 1;
	case CTRL('U'):
	case KEY_SDC:
		if (Rcp[Cursor].type == RC_LIST)
			beep();
		else
			strcpy(ChPtr = ChBuf, "");
		break;
	case 0x7f:
	case KEY_DC:
		if (Rcp[Cursor].type == RC_LIST)
			beep();
		else if (*ChPtr)
			memmove(ChPtr, ChPtr+1, strlen(ChPtr+1)+1);
		else
			beep();
		break;
	case KEY_DOWN:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
			goto next_choice;
		beep();
		break;
	case KEY_UP:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
			goto prev_choice;
		beep();
		break;
	case KEY_LEFT:
		if (Rcp[Cursor].type == RC_LIST)
		{
		prev_choice:
			--CurChoice;
			if (CurChoice < 0)
				CurChoice = NumChoice - 1;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
		{
			if (ChPtr > ChBuf)
				--ChPtr;
			else
				beep();
		}
		break;
	case KEY_RIGHT:
		if (Rcp[Cursor].type == RC_LIST)
		{
		next_choice:
			++CurChoice;
			if (CurChoice >= NumChoice)
				CurChoice = 0;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
		{
			if (*ChPtr)
				++ChPtr;
			else
				beep();
		}
		break;
	case KEY_END:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
		{
			CurChoice = NumChoice - 1;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
			ChPtr = strchr(ChBuf, 0);
		break;
	case KEY_HOME:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
		{
			CurChoice = 0;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
			ChPtr = ChBuf;
		break;
	case '\b':
		if (Rcp[Cursor].type == RC_LIST)
			goto prev_choice;
		else if (ChPtr > ChBuf)
		{
			--ChPtr;
			memmove(ChPtr, ChPtr+1, strlen(ChPtr+1)+1);
		}
		else
			beep();
		break;
	case CTRL('p'):
		ShowPassword = !ShowPassword;
		for (y = 0; y < getmaxy(Subwin); ++y)
			display_pref_line(&Rcp[Top+y], y, 0);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		touchwin(Win);
		goto justshow;
	default:
		if (Rcp[Cursor].type == RC_LIST)
		{
			if (c == ' ')
				goto next_choice;
			if (c == 'q')
				goto abort;
			if (c == 's')
				goto save;
			beep();
			break;
		}
		if (Rcp[Cursor].type == RC_NUM && (c < '0' || c > '9') )
		{
			beep();
			break;
		}
		if (c >= ' ' && c < 127)
		{
			if (NewChange)
				strcpy(ChPtr = ChBuf, "");
			memmove(ChPtr+1, ChPtr, strlen(ChPtr)+1);
			*ChPtr++ = c;
		}
		else
			beep();
		break;
	}

	NewChange = 0;
justshow:
	show_change(&Rcp[Cursor]);
	return 0;
}

static void
popdown(void)
{
	blankrect(LINES-2, 0, LINES-1, COLS-1, 0);
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = NULL;
}

int
srpref_command(int c, STREAMER sr)
{
	static int	(*handler)(int c, STREAMER sr);
	int		y;
	int		rc;
	RCFILE		*rcp;
	MEVENT		m;

	if (handler)
	{
		rc = (*handler)(c, sr);
		if (rc > 0)
		{
			handler = NULL;
			rc = 0;
		}
		else if (rc == 0)
		{
			touchwin(Win);
			move(LINES-1, CursorX);
			update_panels(); refresh(); // doupdate();
			wrefresh(curscr);	// Hack for panel refresh prob
		}
		return rc;
	}

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return 0;
	case '?':
		// handler = help_command;
		// help_popup("pref");
		break;
	case '\r':
	case 'c':
		if (Cursor == 0)
		{
			++SrTmp;
			if (!SrTmp->name)
				SrTmp = SrList;
			find_streamer(SrTmp->name);
			Rcp = SrTmp->rcfile;
			display_sr(Rcp);
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		break;
	case 'f':
		rcp = &Rcp[Cursor];
		if (rcp->value)
			free(rcp->value);
		rcp->value = strdup(rcp->defvalue);
		if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
		{
			char	*p = strchr(rcp->value, '|');
			if (p) *p = 0;
		}
		display_pref_line(rcp, Cursor, TRUE);
		touchwin(Win);
		break;
	case 'F':
		for (y = 0, rcp = Rcp; rcp->name; ++rcp, ++y)
		{
			if (rcp->value)
				free(rcp->value);
			rcp->value = strdup(rcp->defvalue);
			if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
			{
				char	*p = strchr(rcp->value, '|');
				if (p) *p = 0;
			}
			display_pref_line(rcp, y, y == Cursor);
		}
		touchwin(Win);
		break;
	case 'j':
	case KEY_DOWN:
		if (++Cursor == NumPrefs)
		{
			--Cursor;
			beep();
			break;
		}
		if (Cursor >= Top+getmaxy(Subwin))
		{
			++Top;
			repaint_pref_lines(Rcp + Top);
		}
		else
			display_pref_line(&Rcp[Cursor-1], Cursor-Top-1, FALSE);
		display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		if (Cursor < Top)
		{
			--Top;
			repaint_pref_lines(Rcp + Top);
		}
		else
			display_pref_line(&Rcp[Cursor+1], Cursor-Top+1, FALSE);
		display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		Top = 0;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'G':
	case KEY_END:
		Cursor = NumPrefs - 1;
		Top = Cursor - getmaxy(Subwin) + 1;
		if (Top < 0)
			Top = 0;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'l':
	case KEY_RIGHT:
		if (Cursor == 0)
		{
			++SrTmp;
			if (!SrTmp->name)
				SrTmp = SrList;
			find_streamer(SrTmp->name);
			Rcp = SrTmp->rcfile;
			display_sr(Rcp);
		}
		else if (Rcp[Cursor].type == RC_LIST)
		{
			make_choice_list(&Rcp[Cursor]);
			++CurChoice;
			if (CurChoice >= NumChoice)
				CurChoice = 0;
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name,
				Choice[CurChoice]);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else if (Rcp[Cursor].type == RC_NUM)
		{
			int	val = atoi(Rcp[Cursor].value);
			char	numbuf[64];

			if (++val > Rcp[Cursor].max)
				val = Rcp[Cursor].min;
			sprintf(numbuf, "%d", val);
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name, numbuf);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		touchwin(Win);
		break;
	case 'h':
	case KEY_LEFT:
		if (Cursor == 0)
		{
			--SrTmp;
			if (SrTmp < SrList)
				SrTmp = SrList + asizeof(SrList) - 2;
			find_streamer(SrTmp->name);
			Rcp = SrTmp->rcfile;
			display_sr(Rcp);
		}
		else if (Rcp[Cursor].type == RC_LIST)
		{
			make_choice_list(&Rcp[Cursor]);
			--CurChoice;
			if (CurChoice < 0)
				CurChoice = NumChoice - 1;
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name,
					Choice[CurChoice]);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else if (Rcp[Cursor].type == RC_NUM)
		{
			int	val = atoi(Rcp[Cursor].value);
			char	numbuf[64];

			if (--val < Rcp[Cursor].min)
				val = Rcp[Cursor].max;
			sprintf(numbuf, "%d", val);
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name, numbuf);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		touchwin(Win);
		break;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		// TODO: position on clicked line
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;

	case CTRL('p'):
		ShowPassword = !ShowPassword;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		touchwin(Win);
		break;

	case 's':
		set_rc_value(RcFile, "streamer", SrTmp->name);
		save_rc_file(SrTmp->rcfile, SrTmp->filename);
		SrCur = SrTmp;
		NewStreamer = 1;
		popdown();
		return 2;

	case 033:
	case 'q':
		popdown();
		return 2;

	default:
		beep();
		return 0;
	}
	return 0;
}
