/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "Hamming.h"

#include <wx/log.h>
#include <wx/debug.h>

#include <cmath>
using namespace std;

CHamming::CHamming(int length) :
m_length(length)
{
	wxASSERT(length > 0);
}

CHamming::~CHamming()
{
}

void CHamming::filter(double* in, double* out) const
{
	wxASSERT(in != NULL);
	wxASSERT(out != NULL);

	for (int i = 0; i < m_length; i++) {
		double h = double(i) * (1.0 / double(m_length - 1));

		out[i] = in[i] * (0.54 - 0.46 * ::cos(2.0 * M_PI * h));
	}
}
