/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	MessageControl_H
#define	MessageControl_H

#include <wx/wx.h>

#include "MessageTextCtrl.h"

const int Text_Messages_Begin   = 300;
const int Button_Messages_Begin = 400;

class CMessageControl : public wxPanel {
    public:
	CMessageControl(wxWindow* parent, int id, wxString* messages, int count, int maxLength);
	virtual ~CMessageControl();

	virtual void setMessage(int n, const wxString& text);
	virtual wxString getMessage(int n) const;

    private:
	int                m_count;
	CMessageTextCtrl** m_messages;
};

#endif
