/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "PersonalPreferences.h"

const int BORDER_SIZE = 5;

CPersonalPreferences::CPersonalPreferences(wxWindow* parent, int id, const wxString& callsign, const wxString& locator) :
wxPanel(parent, id),
m_callsign(NULL),
m_locator(NULL)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* callsignSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* callsignLabel = new wxStaticText(this, -1, wxT("Callsign"));
	callsignSizer->Add(callsignLabel, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	m_callsign = new CCallsignTextCtrl(this, -1, callsign);
	callsignSizer->Add(m_callsign, 0, wxALL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(callsignSizer, 0, wxALL, BORDER_SIZE);

	wxBoxSizer* locatorSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* locatorLabel = new wxStaticText(this, -1, wxT("Locator"));
	locatorSizer->Add(locatorLabel, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	m_locator = new CLocatorTextCtrl(this, -1, locator);
	locatorSizer->Add(m_locator, 0, wxALL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(locatorSizer, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}


CPersonalPreferences::~CPersonalPreferences()
{
}

bool CPersonalPreferences::isCallsignValid() const
{
	if (!m_callsign->Validate())
		return false;

	wxString callsign = m_callsign->GetValue();

	return !callsign.IsEmpty();
}

bool CPersonalPreferences::isLocatorValid() const
{
	if (!m_locator->Validate())
		return false;

	wxString locator = m_locator->GetValue();

	return !locator.IsEmpty();
}

wxString CPersonalPreferences::getCallsign() const
{
	return m_callsign->GetValue().MakeUpper();
}

wxString CPersonalPreferences::getLocator() const
{
	return m_locator->GetValue().MakeUpper();
}
