/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FSK441Lookups_H
#define	FSK441Lookups_H

#include <wx/string.h>

struct toneStruct {
	wxString text;
	int      t1;
	int      t2;
	int      t3;
};

static const struct toneStruct singleToneTable[] = {
	{wxT("R26"), 0, 0, 0},
	{wxT("R27"), 1, 1, 1},
	{wxT("RRR"), 2, 2, 2},
	{wxT("73"),  3, 3, 3}
};
	
static const struct toneStruct multiToneTable[] = {
	{wxT("0"), 2, 2, 3}, {wxT("1"), 0, 0, 1}, {wxT("2"), 0, 0, 2},
	{wxT("3"), 0, 0, 3}, {wxT("4"), 0, 1, 0}, {wxT("5"), 0, 1, 1},
	{wxT("6"), 0, 1, 2}, {wxT("7"), 0, 1, 3}, {wxT("8"), 0, 2, 0},
	{wxT("9"), 0, 2, 1}, {wxT("."), 0, 2, 2}, {wxT(","), 0, 2, 3},
	{wxT("?"), 0, 3, 0}, {wxT("/"), 0, 3, 1}, {wxT("#"), 0, 3, 2},
	{wxT(" "), 0, 3, 3}, {wxT("$"), 1, 0, 0}, {wxT("A"), 1, 0, 1},
	{wxT("a"), 1, 0, 1}, {wxT("B"), 1, 0, 2}, {wxT("b"), 1, 0, 2},
	{wxT("C"), 1, 0, 3}, {wxT("c"), 1, 0, 3}, {wxT("D"), 1, 1, 0},
	{wxT("d"), 1, 1, 0}, {wxT("E"), 2, 3, 0}, {wxT("e"), 2, 3, 0},
	{wxT("F"), 1, 1, 2}, {wxT("f"), 1, 1, 2}, {wxT("G"), 1, 1, 3},
	{wxT("g"), 1, 1, 3}, {wxT("H"), 1, 2, 0}, {wxT("h"), 1, 2, 0},
	{wxT("I"), 1, 2, 1}, {wxT("i"), 1, 2, 1}, {wxT("J"), 1, 2, 2},
	{wxT("j"), 1, 2, 2}, {wxT("K"), 1, 2, 3}, {wxT("k"), 1, 2, 3},
	{wxT("L"), 1, 3, 0}, {wxT("l"), 1, 3, 0}, {wxT("M"), 1, 3, 1},
	{wxT("m"), 1, 3, 1}, {wxT("N"), 1, 3, 2}, {wxT("n"), 1, 3, 2},
	{wxT("O"), 1, 3, 3}, {wxT("o"), 1, 3, 3}, {wxT("P"), 2, 0, 0},
	{wxT("p"), 2, 0, 0}, {wxT("Q"), 2, 0, 1}, {wxT("q"), 2, 0, 1},
	{wxT("R"), 2, 0, 2}, {wxT("r"), 2, 0, 2}, {wxT("S"), 2, 0, 3},
	{wxT("s"), 2, 0, 3}, {wxT("T"), 2, 1, 0}, {wxT("t"), 2, 1, 0},
	{wxT("U"), 2, 1, 1}, {wxT("u"), 2, 1, 1}, {wxT("V"), 2, 1, 2},
	{wxT("v"), 2, 1, 2}, {wxT("W"), 2, 1, 3}, {wxT("w"), 2, 1, 3},
	{wxT("X"), 2, 2, 0}, {wxT("x"), 2, 2, 0}, {wxT("Y"), 2, 2, 1},
	{wxT("y"), 2, 2, 1}, {wxT("Z"), 2, 3, 1}, {wxT("z"), 2, 3, 1}
};

class CFSK441Lookups {

    public:
	CFSK441Lookups();
	virtual ~CFSK441Lookups();

	virtual bool lookupChar(const wxString& text, int& t1, int& t2, int& t3) const;
	virtual bool lookupSingleTones(int t1, int t2, int t3, wxString& text) const;
	virtual bool lookupMultiTones(int t1, int t2, int t3, wxString& text) const;

    private:
};

#endif
