/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441ProtocolPreferences.h"

const int BORDER_SIZE = 5;

CFSK441ProtocolPreferences::CFSK441ProtocolPreferences(wxWindow* parent, int id, bool singleTone) :
wxPanel(parent, id),
m_singleToneButton(NULL)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	m_singleToneButton = new wxCheckBox(this, -1, wxT("Single Tone Receive"));
	m_singleToneButton->SetValue(singleTone);
	sizer->Add(m_singleToneButton, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CFSK441ProtocolPreferences::~CFSK441ProtocolPreferences()
{
}

bool CFSK441ProtocolPreferences::getSingleTone() const
{
	wxASSERT(m_singleToneButton != NULL);

	return m_singleToneButton->GetValue();
}
