/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44SunMoonDisplay.h"

#include "jt44/JT44Defs.h"

const int BORDER_SIZE = 5;

CJT44SunMoonDisplay::CJT44SunMoonDisplay(wxWindow* parent, int id, const wxString& locator, int band) :
wxPanel(parent, id),
m_panel(NULL),
m_band(NULL)
{
	wxASSERT(parent != NULL);

	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	m_panel = new CSunMoonPanel(this, -1, wxDefaultPosition, wxSize(JT44_GRAPH_WIDTH, JT44_MOON_HEIGHT));
	sizer->Add(m_panel, 0, wxTOP, BORDER_SIZE);

	m_band = new wxChoice(this, Choice_Band, wxDefaultPosition, wxSize(100, -1));
	m_band->Append(wxT("50 MHz"), (void *)Band_50MHz);
	m_band->Append(wxT("70 MHz"), (void *)Band_70MHz);
	m_band->Append(wxT("144 MHz"), (void *)Band_144MHz);
	m_band->Append(wxT("220 MHz"), (void *)Band_220MHz);
	m_band->Append(wxT("432 MHz"), (void *)Band_432MHz);
	m_band->Append(wxT("902 MHz"), (void *)Band_902MHz);
	m_band->Append(wxT("1296 MHz"), (void *)Band_1296MHz);
	m_band->Append(wxT("2304 MHz"), (void *)Band_2304MHz);
	m_band->Append(wxT("3400 MHz"), (void *)Band_3400MHz);
	m_band->Append(wxT("5760 MHz"), (void *)Band_5760MHz);
	m_band->Append(wxT("10368 MHz"), (void *)Band_10368MHz);
	m_band->Append(wxT("24192 MHz"), (void *)Band_24192MHz);
	sizer->Add(m_band, 0, wxALL, BORDER_SIZE);

	setBand(band);

	m_panel->setLocator(locator);

	SetAutoLayout(true);
	sizer->Fit(this);
	sizer->SetSizeHints(this);
	SetSizer(sizer);
}

CJT44SunMoonDisplay::~CJT44SunMoonDisplay()
{
}

void CJT44SunMoonDisplay::setBand(int band)
{
	wxASSERT(m_panel != NULL);
	wxASSERT(m_band != NULL);

	int selection = Band_144MHz;

	switch (band) {
		case 50:  selection = Band_50MHz;  break;
		case 70:  selection = Band_70MHz;  break;
		case 144: selection = Band_144MHz; break;
		case 220: selection = Band_220MHz; break;
		case 432: selection = Band_432MHz; break;
		case 902: selection = Band_902MHz; break;
		case 1296:  selection = Band_1296MHz; break;
		case 2304:  selection = Band_2304MHz; break;
		case 3400:  selection = Band_3400MHz; break;
		case 5750:  selection = Band_5760MHz; break;
		case 10368: selection = Band_10368MHz; break;
		case 24192: selection = Band_24192MHz; break;
	}	

	m_band->SetSelection(selection);		
	m_panel->setFrequency(double(band));
}

int CJT44SunMoonDisplay::getBand() const
{
	wxASSERT(m_panel != NULL);
	wxASSERT(m_band != NULL);

	int band = m_band->GetSelection();

	switch (band) {
		case Band_50MHz:  band = 50;  break;
		case Band_70MHz:  band = 70;  break;
		case Band_144MHz: band = 144; break;
		case Band_220MHz: band = 220; break;
		case Band_432MHz: band = 432; break;
		case Band_902MHz: band = 902; break;
		case Band_1296MHz:  band = 1296; break;
		case Band_2304MHz:  band = 2304; break;
		case Band_3400MHz:  band = 3400; break;
		case Band_5760MHz:  band = 5760; break;
		case Band_10368MHz: band = 10368; break;
		case Band_24192MHz: band = 24192; break;
	}	

	m_panel->setFrequency(double(band));

	return band;
}
