# Copyright (C) 2002,2004 Stichting LogReport Foundation logreport@logreport.org

# This file is part of Lire.

# Lire is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (see COPYING); if not, check with
# http://www.gnu.org/copyleft/gpl.html or write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

# Author:
#   Francis J. Lacoste <flacoste@logreport.org>

package Lire::DlfAnalysers::UserAgentCategoriser;

use strict;

use base qw/Lire::DlfCategoriser/;

use Lire::WWW::UserAgent;

sub new {
    return bless {}, shift;
}

sub name {
    return "www-user_agent";
}

sub title {
    return "UserAgent DlfAnalyser";
}

sub description {
    return '<para>This categoriser extracts browser, os and language information from the <structfield>useragent</structfield> field.</para>';
}

sub src_schema {
    return "www";
}

sub dst_schema {
    return "www-user_agent";
}

sub initialise {
    my ( $self, $config ) = @_;

    $self->{'analyser'} =
      new Lire::WWW::UserAgent( 'os_default' => 'LIRE_UNDEF',
                                'language_default' => 'LIRE_UNDEF',
                                'browser_default' => 'LIRE_UNDEF',
                              );
    return;
}

sub categorise {
    my ( $self, $dlf ) = @_;

    return unless defined $dlf->{'useragent'};
    $self->{'analyser'}->setUserAgent( $dlf->{ 'useragent'} );

    $dlf->{'os'} = $self->{'analyser'}->getOS();
    $dlf->{'lang'} = $self->{'analyser'}->getLanguage();
    $dlf->{'browser'} = $self->{'analyser'}->getBrowser();

    foreach my $field ( qw/os lang browser/ ) {
        $dlf->{$field} = undef if $dlf->{$field} eq 'LIRE_UNDEF';
    }

    return;
}

# keep perl happy
1;
