#line 2 "apache_eapi.c"

/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: apache_eapi.c,v 1.4 2002/02/03 11:13:41 dolecek Exp $ */

/* no need to include anything, apache.c includes everything we need
 * for us (*.c are concatenated into one big mod_csacek.c) */

#ifdef EAPI

#include <sys/uio.h>

/*
 * This file contains CSacek's Apache EAPI specific code. Most of this are
 * just stubs for now. Stay tuned.
 */

#if notyet
/* this is set to point at mod_ssl module structure, when loaded */
static module *mod_ssl_module = NULL;

/* local functions */
static int x_csa_eapi_read __P((BUFF *, void *, int));
static int x_csa_eapi_write __P((BUFF *, const void *, int));
static int x_csa_eapi_writev __P((BUFF *, const struct iovec *, int));
#endif

void
csa_eapi_init()
{
#if notyet
	/*
	 * We need to reconfigure ap::buff:* to AP_HOOK_ALL. The sig
	 * has to be same as the one specified in the original initialization
	 * code in http_main.c.
	 */
	ap_hook_configure("ap::buff::read", 
		AP_HOOK_SIG4(int,ptr,ptr,int), AP_HOOK_ALL);
	ap_hook_configure("ap::buff::write",  
		AP_HOOK_SIG4(int,ptr,ptr,int), AP_HOOK_ALL);
#ifndef NO_WRITEV
	ap_hook_configure("ap::buff::writev",  
		AP_HOOK_SIG4(int,ptr,ptr,int), AP_HOOK_ALL);
#endif

	/*
	 * Yes, this is a hack, but needed - the EAPI has no way to tell
	 * the order in which hooks are called - new hooks are always put
	 * on start of hook array. CSacek needs to "read"
	 * _after_ the SSL read is done and "write" before it. It has to
	 * register it's "read" routine before mod_ssl, so that it appears
	 * after mod_ssl's "read" routine; CSacek "write" routines need
	 * to be added after mod_ssl's "write" routines, so that CSacek ones
	 * are called before mod_ssl ones.
	 */
	if (mod_ssl_module) {
		/* mod_ssl was loaded, deinitialize it */
		mod_ssl_module->remove_module(mod_ssl_module);
	}
	ap_hook_register("ap::buff::read", x_csa_eapi_read, AP_HOOK_NOCTX);
	if (mod_ssl_module) {
		/* initialize mod_ssl again */
		mod_ssl_module->add_module(mod_ssl_module);
	}
	ap_hook_register("ap::buff::write", x_csa_eapi_write, AP_HOOK_NOCTX);
#ifndef NO_WRITEV
	ap_hook_register("ap::buff::writev", x_csa_eapi_writev, AP_HOOK_NOCTX);
#endif /* NO_WRITEV */
#endif /* notyet */
}

#if 0
static int
x_csa_eapi_read(BUFF *fb, void *buf, int len)
{
	printf("csa_eapi_read\n");
	return read(fb->fd_in, buf, len);
}

static int
x_csa_eapi_write(BUFF *fb, const void *buf, int len)
{
	char *copy = alloca(len + 1);
	conn_rec *conn = ap_ctx_get(fb->ctx, "csacek");
	
	memcpy(copy, buf, len);
	copy[len] = 0;
	ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR,
		conn->server, "csa_eapi_write: %s", copy);
	return write(fb->fd, buf, len);
}

#ifndef NO_WRITEV
static int
x_csa_eapi_writev(BUFF *fb, const struct iovec *iov, int iovcnt)
{
	printf("csa_eapi_writev\n");
	return writev(fb->fd, iov, iovcnt);
}
#endif /* NO_WRITEV */
#endif /* 0 */

/*
 * Hook to find out if mod_ssl has been loaded. This is a hack, but
 * necessary for later filter registering.
 */
void
csa_eapi_addmodule(module *m)
{
#if 0
	if (strcasecmp(m->name, "mod_ssl.c") == 0)
		mod_ssl_module = m;
#endif
};

/*
 * This is called on module removal.
 */
void
csa_eapi_removemodule(module *m)
{
#if 0
	if (m == mod_ssl_module)
		mod_ssl_module = NULL;
	else if (m == &csacek_module) {
		ap_hook_unregister("ap::buff::read", x_csa_eapi_read);
		ap_hook_unregister("ap::buff::write", x_csa_eapi_write);
#ifndef NO_WRITEV
		ap_hook_unregister("ap::buff::writev", x_csa_eapi_writev);
#endif
	}
#endif /* 0 */
};

/*
 * Hook called after connection is eastablished but before any data is
 * read.
 */
void
csa_eapi_newconnection(conn_rec *conn)
{
#if 0
	ap_ctx_set(conn->client->ctx, "csacek", conn);
#endif
}

/*
 * This is called just before a connection is closed.
 */
void
csa_eapi_closeconnection(conn_rec *conn)
{
#if 0
	ap_ctx_set(conn->client->ctx, "csacek", NULL);
#endif
}

#endif /* EAPI */
