/*-------------------------------------------------------------------------------

Copyright (c) 2001 CerebraSoft

Module Name:

	NTServerStats.h

Abstract:

	mod backhand serverstat structure, modified for NT broadcaster.

License:

   All rights reserved.

   This product includes software developed at The Center for
   Networking and Distributed Systems at The Johns Hopkins University
   for use in the Backhand project (http://www.cnds.jhu.edu/backhand).
     Creator: Theo Schlossnagle 
     Guidance: Yair Amir

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer. 
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
 
  3. All advertising materials mentioning features or use of this
     software must display the following acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  4. The names "Backhand Broadcaster" and "NT Backhand Broadcaster" must
     not be used to endorse or promote products derived from this
     software without prior written permission. For written permission,
     please contact www.cerebrasoft.com.
 
  5. Products derived from this software may not be called "Backhand Broadcaster"
     or "NT Backhand Broadcaster" nor may "Backhand Broadcaster" or
     "NT Backhand Broadcaster" appear in their names without prior written
     permission. For written permission, please contact www.cerebrasoft.com.
 
  6. Redistributions of any form whatsoever must retain the following
     acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
  OF THE POSSIBILITY OF SUCH DAMAGE.
---------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------
	serverstat structure

		Borrowed from mod_backhand serverstat.h

		(some modifications have been made.)

		Original notice as in serverStat.h

		======================================================================
		Copyright (c) 1998-1999 The Johns Hopkins University.
		All rights reserved.
		The following code was written by Theo Schlossnagle for use in the
		Backhand project at The Center for Networking and Distributed Systems
		at The Johns Hopkins University.
		Please refer to the LICENSE file before using this software.
		======================================================================
---------------------------------------------------------------------------------*/
#include <time.h>

typedef struct {

		// General information concerning the server and this structure

	char hostname[40];	// or truncated hostname as the case may be
		// later this may be changed to an int 64
	time_t mtime;		// (always ignored by receiver, set to 0)
	struct sockaddr_in contact;	// inet addr + port

	// Statistics for decision making
	int arriba;	// How fast is THIS machine.
	int aservers;	// (always ignored by receiver, set to 0)  
	int nservers;	// (always ignored by receiver, set to 0) 
	int load;	// load
	int load_hwm;	// (always ignored by receiver, set to 0) 
	int cpu;	// cpu idle time
	int ncpu;	// number of CPUs (load doesn't mean too much otherwise)
	int tmem;	// total memory installed (in bytes)
	int amem;	// available memory
	int numbacked;	// (always ignored by receiver, set to 0) 
	int tatime;	// (always ignored by receiver, set to 0) 
} serverstat;

	//We are only broadcasting, don't waste time converting items which are ignored anyway.
#define serverstat_endian_convert(a, f) {\
    (a).load = f((a).load);\
    (a).cpu = f((a).cpu);\
    (a).tmem = f((a).tmem);\
    (a).amem = f((a).amem);\
} 	// no need to convert most data, it is converted to network byte order when we load it or it is ignored.


	// hton(s|l) for serverstats You need to call this before sending out a serverstat 
#define htonss(a) serverstat_endian_convert(a,htonl)
