//$Id: hellowindow.cc,v 1.6 2003/11/17 23:01:49 bowens Exp $ -*- c++ -*-

/* bonobomm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "hellowindow.h"
#include "uicomponent_impl.h"
#include <algorithm> //For std::reverse()
#include <fstream>
#include <libbonoboui.h>

#include <gtkmm/frame.h>

#define HELLO_UI_XML "Bonobo_Sample_Hello.xml"

HelloWindow::HelloWindow () :
    m_Button("Hello, Bonobomm World")
{
    //Do Bonobo stuff:
    try
    {
	/* Container: */
	Bonobo::UIContainer_var cppContainer = get_ui_container();
	Bonobo::UIComponent_var cppComponent = m_servant._this();
	
	/* This determines where the UI configuration info. will be stored */
	//TODO: bonobo_ui_engine_config_set_path (bonobo_window_get_ui_engine (win), "/hello-app/UIConfig/kvps");
	
	/* Associate the BonoboUIComponent with the container */
	cppComponent->setContainer (cppContainer);
	
	/* NB. this creates a relative file name from the current dir,
	 * in production you want to pass the application's datadir
	 * see Makefile.am to see how HELLO_SRCDIR gets set. */
	char* fname = bonobo_ui_util_get_ui_fname ("", HELLO_SRCDIR HELLO_UI_XML);
	
	// In C,, bonobo_ui_util_set_ui() changes the XML file, doing some translation stuff:
	// bonobo_ui_util_set_ui (ui_component, "", /* data dir */ HELLO_SRCDIR HELLO_UI_XML, "bonobo-hello", NULL);
	// This is slightly better, but still use a wrapper object:
	// Use bonobo C functions to get the XML.
	//  bonobo_ui_util_new_ui() does a lot of funky stuff to change the XML.
	//  BonoboUINode* node = bonobo_ui_util_new_ui (ui_component, fname, "", "bonobo-hello");
	//  const char* ui = bonobo_ui_node_to_string (node, true);
	//  bonobo_ui_node_free (node);
	
	//Read in the XML file:
	std::string strXML;
	std::ifstream fStream (fname);
	if (fStream.is_open ())
	{
	    while(!(fStream.eof ()))
	    {
		char chTemp = fStream.get ();
		if(!(fStream.eof ()))
		    strXML += chTemp;
	    }
	}
	
	cppContainer->setNode ("/", strXML.c_str(), cppComponent->name());
    } catch (const CORBA::Exception& ex) {
	g_warning("debug: CORBA::Exception\n");
    }
    
    //Do regular GTK+ stuff:
    
    set_resizable ();
    set_default_size (250, 350);
    
    //Button:
    m_Button.set_border_width (10);
    m_Button.signal_clicked ().connect (SigC::slot (*this, &HelloWindow::on_button_clicked));
    
    
    //Frame:
    Gtk::Frame *frame = new Gtk::Frame;
    frame->set_shadow_type (Gtk::SHADOW_IN);
    frame->add (m_Button);
    set_contents(*manage (frame));
    
    show_all_children ();
}

void HelloWindow::on_button_clicked()
{
    // reverse the string. FIXME: this is not UTF-8-safe
    std::string s = m_Button.get_label ();
    std::reverse (s.begin(), s.end());
    m_Button.set_label (s);
}
