/***************************************************************************
 $RCSfile: ctcardbase.h,v $
                             -------------------
    cvs         : $Id: ctcardbase.h,v 1.1 2003/04/24 01:49:28 aquamaniac Exp $
    begin       : Wed Apr 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CTCARDBASE_H
#define CTCARDBASE_H

#include <chipcard/ctpointer.h>
#include <chipcard/ctreadercontext.h>
#include <chipcard/ctreadertrader.h>

#include <string>
using namespace std;


/**
 *
 */
class CTCardBase {
public:
  typedef enum {
    CallBackContinue=0,
    CallBackAbort
  } CallBackResult;

protected:

private:
  int _openCount;
  int _timeout;
  CTReaderContext _reader;
  string _atr;

  int _responseLoop(int reqid, int maxloop);
  CTError _abortConnect(int prevreq, int timeout);

  CTError allocate();
  CTError release();
  CTError connect(string &atr);
  CTError disconnect();
  CTError command(const string &apdu, string &response);

public:
  CTCardBase(const CTReaderContext &ctx);

  /**
   *
   */
  CTCardBase(const CTCardBase &c);

  virtual ~CTCardBase();

  virtual CallBackResult callback(bool first);

  CTError open();
  CTError close(bool force=false);
  bool isOpen() const { return _openCount>0;};

  /**
   * Returns the ATR-String. This string is received upon reset of a
   * chip card and holds interesting information about the card.
   * This class itself gathers much information from this answer, but you
   * rarely need this.
   * This is only valid if the card is open.
   * @author Martin Preuss<martin@libchipcard.de>
   * @return the ATR string
   */
  const string atr() const { return _atr;};

  /**
   * Returns the reader flags of the currently used reader
   * Possible flags are (bits can be ORed):
   * <ul>
   *  <li>CHIPCARD_READERFLAGS_KEYPAD</li>
   *  <li>CHIPCARD_READERFLAGS_DISPLAY</li>
   * </ul>
   * These flags are only valid if the card is open.
   */
  unsigned int readerFlags() const;

  unsigned int readerStatus() const;

  /**
   *
   */
  const CHIPCARD_READERDESCR &readerDescription() const;

  /**
   * Set the timeout when waiting for a server response (default is
   * 30 seconds).
   * @param t timeout in seconds
   */
  void setTimeout(int t) { _timeout=t;};

  /**
   * Get the timeout when waiting for a server response (default is
   * 30 seconds).
   */
  int timeout() const { return _timeout;};

  /**
   * This method sends a raw APDU to the card reader and returns the answer.
   */
  CTError sendAPDU(const string &apdu, string &response);

};




#endif


