/* 
 * $Id: ctkclist.h,v 1.11 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKCLIST_H__
# define __CTKCLIST_H__ 

#include "ctkadjustment.h"

typedef struct CtkCList_S {
	CtkTable table;
	
	gint selected_row;
	gint selected_col;
	gint cursor_row;

	gboolean frozen;
	gboolean column_show;
} CtkCList;

#define CTK_CLIST(obj)	CTK_CHECK_CAST((obj),CtkCList,CtkTypeCList)

void ctk_clist_init(CtkCList *clist, gint columns);
CtkWidget *ctk_clist_new(gint columns);
void ctk_clist_set_column_widget(CtkCList *clist, gint column, CtkWidget *widget);
void ctk_clist_set_column_title(CtkCList *clist, gint column, const gchar *text);
void ctk_clist_set_column_width(CtkCList *clist, gint column, gint width);
void ctk_clist_column_titles_show(CtkCList *clist);
void ctk_clist_column_titles_hide(CtkCList *clist);
void ctk_clist_append_widget(CtkCList* clist, CtkWidget* widgets[]);
void ctk_clist_append(CtkCList *clist, gchar *text[]);
void ctk_clist_prepend_widget(CtkCList *clist, CtkWidget* widgets[]);
void ctk_clist_prepend(CtkCList *clist, gchar *text[]);
void ctk_clist_insert_widget(CtkCList *clist, gint row, CtkWidget* widgets[]);
void ctk_clist_insert(CtkCList *clist, gint row, gchar *text[]);
void ctk_clist_clear(CtkCList *clist);
void ctk_clist_freeze(CtkCList *clist);
void ctk_clist_thaw(CtkCList *clist);
gint ctk_clist_get_widget(CtkCList* clist, gint row, gint col, CtkWidget** widget);
gint ctk_clist_get_text(CtkCList *clist, gint row, gint col, gchar **text);
void ctk_clist_set_text(CtkCList *clist, gint row, gint col, const gchar *text);
void ctk_clist_select_row(CtkCList *clist, gint row, gint column);
void ctk_clist_unselect_row(CtkCList *clist, gint row, gint column);
void ctk_clist_move_cursor(CtkCList* clist, gint amount);
void ctk_clist_remove(CtkCList *clist, gint row);

void ctk_clist_min_size (CtkWidget* widget);
void ctk_clist_real_size(CtkWidget* widget);

#endif
