#--
# =============================================================================
# Copyright (c) 2004, Jamis Buck (jgb3@email.byu.edu)
# All rights reserved.
#
# This source file is distributed as part of the Net::SFTP Secure FTP Client
# library for Ruby. This file (and the library as a whole) may be used only as
# allowed by either the BSD license, or the Ruby license (or, by association
# with the Ruby license, the GPL). See the "doc" subdirectory of the Net::SFTP
# distribution for the texts of these licenses.
# -----------------------------------------------------------------------------
# net-sftp website: http://net-ssh.rubyforge.org/sftp
# project website : http://rubyforge.org/projects/net-ssh
# =============================================================================
#++

$:.unshift "../../../lib"
$:.unshift File.join( File.dirname( __FILE__ ), ".." )

require 'net/sftp/protocol/04/impl'
require '03/tc_impl'

class TC_04_Impl < TC_03_Impl

  def impl_class
    Net::SFTP::Protocol::V_04::Impl
  end

  unless defined?( IO_FLAGS_V4 )
    IO_FLAGS_V4 = [ IO::RDONLY, IO::WRONLY, IO::RDWR, IO::APPEND ]
    OTHER_FLAGS_V4 = [ 0, IO::CREAT, IO::TRUNC, IO::EXCL ]
    FLAG_MAP_V4 = { IO::RDONLY => 2, IO::WRONLY => 1, IO::RDWR => 3,
      IO::APPEND => 11, IO::CREAT => 3, IO::TRUNC => 4 }
    ACCESS_MAP_V4 = { IO::RDONLY => 0x81, IO::WRONLY => 0x102,
      IO::RDWR => 0x183, IO::APPEND => 0x106 }

    IO_FLAGS_V4.each do |flag|
      OTHER_FLAGS_V4.each do |oflag|
        [ nil, 0400 ].each do |mode|
          define_method( "test_open_#{flag}_#{oflag}_#{mode||"nil"}" ) do
            return if oflag == IO::EXCL
            @assistant.mock_handle( :open ) { |*a| [ a[0], a[1..-1] ] }
            args = [ 14, "a path", flag | oflag ]
            args << mode if mode
            assert_equal 14, @impl.open( *args )
            assert_equal 1, @assistant.mock_count( :open )
            assert_equal( ( mode || 0660 ), @permissions )
            sftp_flag = FLAG_MAP_V4[flag] |
              ( oflag == 0 ? 0 : FLAG_MAP_V4[oflag] )
            access_flag = ACCESS_MAP_V4[flag]
            assert_equal Net::SFTP::Protocol::Constants::FXP_OPEN,
              @sent_data.first[0]
            assert_equal [ "a path", access_flag, sftp_flag ],
              @sent_data.first[1][0,3]
          end
        end
      end
    end
  end

  def test_stat_flags
    @assistant.mock_handle( :stat ) { |*a| [ a[0], a[1..-1] ] }
    id = @impl.stat( 14, :a, :b )
    assert_equal 14, id
    assert_equal 1, @assistant.mock_count( :stat )
    assert_equal 1, @driver.mock_count( :send_data )
    assert_equal [
      [ Net::SFTP::Protocol::Constants::FXP_STAT, [ :a, :b ]] ], @sent_data
  end

  def test_lstat_flags
    @assistant.mock_handle( :lstat ) { |*a| [ a[0], a[1..-1] ] }
    id = @impl.lstat( 14, :a, :b )
    assert_equal 14, id
    assert_equal 1, @assistant.mock_count( :lstat )
    assert_equal 1, @driver.mock_count( :send_data )
    assert_equal [
      [ Net::SFTP::Protocol::Constants::FXP_LSTAT, [ :a, :b ]] ], @sent_data
  end

  def test_fstat_flags
    @assistant.mock_handle( :fstat ) { |*a| [ a[0], a[1..-1] ] }
    id = @impl.fstat( 14, :a, :b )
    assert_equal 14, id
    assert_equal 1, @assistant.mock_count( :fstat )
    assert_equal 1, @driver.mock_count( :send_data )
    assert_equal [
      [ Net::SFTP::Protocol::Constants::FXP_FSTAT, [ :a, :b ]] ], @sent_data
  end

  def test_rename_flags
    @assistant.mock_handle( :rename ) { |*a| [ a[0], a[1..-1] ] }
    id = @impl.rename( 14, :a, :b, :c )
    assert_equal 14, id
    assert_equal 1, @assistant.mock_count( :rename )
    assert_equal 1, @driver.mock_count( :send_data )
    assert_equal [
      [ Net::SFTP::Protocol::Constants::FXP_RENAME, [ :a, :b, :c ]] ],
      @sent_data
  end

end
