%define name    libnjb
%define	version	1.0.2
# Final releases: "1" = release number of final release, version 1
# CVS releases  : "0.yyyymmdd" = prerelease from CVS at date
#                 "0.yyyymmdd.rh9" = For Redhat 9
#                 "0.yyyymmdd.fc1" = For fedora core 1
# Distributions : "1.rh9" = version 1 for redhat 9, release 1
#                 "1.fc1" = version 1 for fedora core 1, release 1
%define	release	0.20040421
%define	prefix	/usr

Name:		%{name}
Version:	%{version}
Release:	%{release}
Summary:	A software library for talking to the Creative Nomad Jukebox
URL:		http://sourceforge.net/projects/libnjb
Packager:	Linus Walleij <triad@df.lth.se>
Group:		System Environment/Libraries
Source:		%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-buildroot
Copyright:	BSD
Prefix:         %{_prefix}
Docdir:		%{prefix}/doc
Requires:       libusb
BuildRequires:	libusb-devel

%description
This package provides a software library for communicating with the
Creative Nomad Jukebox line of MP3 players.

%package samples
Summary:        Sample programs for talking to the Creative Nomad Jukebox
Group:          System Environment/Libraries
Requires:       %{name} = %{version}

%description samples
This package provides sample programs for communicating with the
Creative Nomad Jukebox line of MP3 players.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make lib samples

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
make prefix=$RPM_BUILD_ROOT%{prefix} install install-samples
# install hotplug scripts so they are up to date
mkdir -p $RPM_BUILD_ROOT/etc/hotplug/usb
install -m 755 nomadjukebox $RPM_BUILD_ROOT/etc/hotplug/usb
install -m 644 nomad.usermap $RPM_BUILD_ROOT/etc/hotplug/usb

%clean
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi

%post -p /sbin/ldconfig
# This is much because RedHat use an old hotplug version that
# doesn't recognize the personalized usermap properly.
function inmap {
    while read LINE; do
	if [ "x${LINE}" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} != "#" ]; then
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${script}" = "x$2" ]; then 
		    if [ "x${manid}" = "x$3" ]; then 
			if [ "x${productid}" = "x$4" ]; then
			    echo "yes"
			    return 0
			fi
		    fi
		fi
	    fi
	fi
    done < $1
    echo "no"
    return 0
}
function patchusermap {
    comment=""
    while read LINE; do
	if [ "x$LINE" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} = "#" ]; then
		comment=${LINE}
	    else
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${manid}" != "x" ]; then
		    echo "Checking for product ${productid} in $2..."
		    if [ `inmap $2 ${script} ${manid} ${productid}` = "no" ]; then
			echo "Not present, adding to hotplug map."
			echo ${LINE} >> $2
			comment=""
		    else
			echo "Already installed."
		    fi
		fi
	    fi
	fi
    done < $1
}
patchusermap /etc/hotplug/usb/nomad.usermap /etc/hotplug/usb.usermap

%postun -p /sbin/ldconfig
# Remove entries from the usermap? What if someone has installed
# another program or from source? No way. See if the "nomadjukebox"
# script is still there, else remove the entries.
if test -f /etc/hotplug/usb/nomadjukebox
then
    # Nothing
    echo "Nothing to remove from usb.usermap."
else
    # Remove any hotplug refs this hairy way
    grep ^'[^n][^o][^m][^a][^d][^j][^u][^k][^e][^b][^o][^x]' /etc/hotplug/usb.usermap > /tmp/gnomad2.tmp
    mv /tmp/gnomad2.tmp /etc/hotplug/usb.usermap
    echo "Removed jukebox entries from usb.usermap."
fi

%files
%defattr(-, root, root)
%{prefix}/lib/*.so
%{prefix}/lib/*.a
%{prefix}/lib/*.la
%{prefix}/include/*.h
%dir /etc/hotplug/usb
%config(noreplace) /etc/hotplug/usb/*
%doc AUTHORS CHANGES FAQ INSTALL LICENSE HACKING

%files samples
%defattr(-, root, root)
%{prefix}/bin/*
%doc AUTHORS CHANGES FAQ INSTALL LICENSE HACKING

%changelog
* Wed Apr 21 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040421
- A new CVS snapshot.
* Fri Apr 9 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040409
- A new CVS snapshot.
* Sun Feb 22 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040222
- A new CVS snapshot. Adressing several bugs.
* Fri Jan 9 2004 Linus Walleij <triad@df.lth.se> 1.0.1-0.20040109
- A new CVS release adressing bugs, better numbering scheme
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0.1-1
- Addressed some issues in 1.0
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0-2
- Second package for samples
* Sat Dec 6 2003 Linus Walleij <triad@df.lth.se> 1.0-1
- Final 1.0 release
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-6
- Seventh RPM
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-5
- Sixth RPM
* Thu Jul 31 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-4
- Fifth RPM
* Wed Jun 11 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-3
- Fourth RPM.
* Mon Apr 21 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-2
- Third RPM, big improvements in hotplug installation.
* Sun Mar 30 2003 Linus Walleij <triad@df.lth.se> 1.1.0b
- Second CVS RPM
* Thu Dec 26 2002 Dwight Engen <dengen40@yahoo.com> 0.9.1
- First RPM'ed
