/* getbalance.c

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "getbalance.h"
#include <stdio.h>
#include <stdlib.h>
#include <openhbci/outboxaccjobs.h>
#include <openhbci/customer.h>
#include <openhbci/bank.h>
#include <locale.h>

HBCI_Error* getBalance(HBCI_API* hbciif,
		      HBCI_CmdLineOptions* opt){
    HBCI_OutboxJobGetBalance* job = 0; 
    int country;
    const char* bankCode;
    const char* accnr;
    const char* user_id;
    HBCI_Account* account = 0;
    const HBCI_Customer* customer = 0;
    HBCI_User* user = 0;
    HBCI_Error* err = 0;
    const char* accountNumber;
    const char* accountName;
    const HBCI_Value *resultvalue = 0;
    const HBCI_AccountBalance *accBal = 0;
    const HBCI_Balance *notedBal = 0, *bookedBal = 0;
    HBCI_Bank *bank = 0;
    const list_HBCI_Customer *cust_list = 0;
    /*list_HBCI_Customer_iter *cust_list_iter = 0, *cust_list_end = 0;*/
    
    accnr = HBCI_CmdLineOptions_getStringVariable(opt, "accnr", "*");
    bankCode = HBCI_CmdLineOptions_getStringVariable(opt, "instid", "*");
    country = HBCI_CmdLineOptions_getIntVariable(opt, "country", 280);
    user_id = HBCI_CmdLineOptions_getStringVariable(opt, "user", "*");
    
    /* get the bank */
    bank = HBCI_API_findBank(hbciif, country, bankCode);
    if (bank == NULL) 
      return HBCI_Error_new("getBalance()",
			    ERROR_LEVEL_NORMAL,
			    0,
			    ERROR_ADVISE_DONTKNOW,
			    "No matching bank found.", " ");

    /* get the given account -- cast is necessary to get rid of const */
    account = (HBCI_Account *) HBCI_Bank_findAccount(bank, accnr);

    /* get the given user -- cast is necessary to get rid of const */
    user = (HBCI_User *) HBCI_Bank_findUser(bank, user_id);

    /* get all the possible customers */
    cust_list = HBCI_User_customers(user);
    if (list_HBCI_Customer_size(cust_list)>1)
	printf("More than one customer per user with user_id %s.\n Aborting -- you would need to implement choosing one of them...\n",
	       HBCI_User_userId(user));
    else
	customer = list_HBCI_Customer_iter_get(
	    list_HBCI_Customer_begin(cust_list));
    
    /* create job for the given account */
    if (account != 0) {
	accountNumber = HBCI_Account_accountId(account);
	accountName = HBCI_Account_accountName(account);

	/* create job for this account */
	job = HBCI_OutboxJobGetBalance_new(customer, account);
	printf("New job for Account Number: %s, Name: %s, BLZ: %s\n   name1: %s, name2: %s\n",
	       accountNumber,
	       accountName, 
	       HBCI_Bank_bankCode(HBCI_Account_bank(account)), 
	       HBCI_Account_name1(account), 
	       HBCI_Account_name2(account)
	       );
	
	/* enqueue job */
	HBCI_API_addJob(hbciif, HBCI_OutboxJobGetBalance_OutboxJob(job));

	HBCI_Hbci_setDebugLevel(3);
	
	printf("Locale: %s\n", setlocale(LC_ALL, NULL));
	setlocale(LC_ALL, "de_DE");
	
	/* and execute the outbox. */
	err = HBCI_API_executeQueue(hbciif, 1);
	printf("Executed outbox with changesAllowed=1\n");
	
	if (!HBCI_Error_isOk(err))
	    return err;

	accBal = HBCI_OutboxJobGetBalance_getBalance(job);
	notedBal = HBCI_AccountBalance_notedBalance(accBal);
	bookedBal = HBCI_AccountBalance_bookedBalance(accBal);
	resultvalue = HBCI_Balance_value(notedBal);
	printf("Noted balance: %s for account no. %s and acc.name %s\n",
	       HBCI_Value_toReadableString(resultvalue), /* this ought to be free'd */
	       accountNumber, accountName);
	resultvalue = HBCI_Balance_value(bookedBal);
	printf("Booked balance: %s for account no. %s and acc.name %s\n",
	       HBCI_Value_toReadableString(resultvalue),
	       accountNumber, accountName);
    } else {
	printf("Sorry, zero matching accounts found. Exiting.\n");
	err = HBCI_Error_new("getBalance()",
			    ERROR_LEVEL_NORMAL,
			    0,
			    ERROR_ADVISE_DONTKNOW,
			    "Zero matching accounts found.", " ");
    }

    return err;
}





