/***************************************************************************
 $RCSfile: userparams.cpp,v $
                             -------------------
    cvs         : $Id: userparams.cpp,v 1.7 2003/01/30 16:22:29 derzach Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "hbcistring.h"
#include "userparams.h"


namespace HBCI {

userParams::userParams(){
  _knowsSupportedUPDJobs = false;
}


userParams::~userParams(){
}


string userParams::dump() const {
    string result;
    list<accountParams>::const_iterator it;

    result+="=========== UserParams =============\n";
    result+="Version ";
    result+=String::num2string(_version)+"\n";
    for (it=_accounts.begin();
         it!=_accounts.end();
         it++) {
        result+="---------- Account --------\n";
        result+=(*it).dump();
    } // for
    return result;
}


} // namespace HBCI
