/***************************************************************************
 $RCSfile: userparams.h,v $
                             -------------------
    cvs         : $Id: userparams.h,v 1.11 2003/01/30 16:22:29 derzach Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef USERPARAMS_H
#define USERPARAMS_H

#include <string>
#include <list>

#include <openhbci/value.h>
#include <openhbci/accountparams.h>

namespace HBCI {

/**
 * @short Stores the User Parameter Data.
 *
 * This is used in the JOBDialogInit and processed by postProcessInitJob.
 */
class DLLIMPORT userParams {
private:
    list<accountParams> _accounts;
    int _version;
	bool _knowsSupportedUPDJobs;

public:
    userParams();
    ~userParams();

    void addAccount(const accountParams &p) { _accounts.push_back(p);};
    const list<accountParams> &accounts() const { return _accounts;};
    int version() const { return _version;};
    void setVersion(int v) { _version=v;};

	/**
	 * @short Tells you if you can rely on the result of 
	 * OutboxJobXXX::isSupported().
	 *
	 * If this method returns <code>false</code> then we don't have any 
	 * information if jobs like OutboxJobNewStandingOrder, OutboxJobTransfer 
	 * ... are supported for the specified Account.<br>
	 * If <code>true</code> is returned, you can be sure that the results of
	 * OutboxJobTransfer::isSupported() ... are valid.
	 */
	bool knowsSupportedJobs() { return _knowsSupportedUPDJobs; };
	/**
	 * @see knowsSupportedJobs()
	 */
	void setKnowsSupportedJobs(bool knowsIt) 
	  { _knowsSupportedUPDJobs = knowsIt; };

    string dump() const;
};

} /* namespace HBCI */


#endif


